/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.ascan;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.Constant;

class FilterMessageTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -6380136823410869457L;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("ascan.filter.table.header.url"), Constant.messages.getString("ascan.filter.table.header.reason")};
    private static final int COLUMN_COUNT = COLUMN_NAMES.length;
    private List<FilteredMessageResult> filteredMessageResults = new ArrayList<FilteredMessageResult>();

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    @Override
    public int getRowCount() {
        return this.filteredMessageResults.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        FilteredMessageResult result = this.filteredMessageResults.get(row);
        switch (col) {
            case 0: {
                return result.url;
            }
            case 1: {
                return result.reason;
            }
        }
        return null;
    }

    public void addResult(String url, String reason) {
        FilteredMessageResult result = new FilteredMessageResult(url, reason);
        this.filteredMessageResults.add(result);
        this.fireTableRowsInserted(this.filteredMessageResults.size() - 1, this.filteredMessageResults.size() - 1);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    private static class FilteredMessageResult {
        protected String url;
        protected String reason;

        protected FilteredMessageResult(String url, String reason) {
            this.url = url;
            this.reason = reason;
        }
    }
}

