/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.ascan;

import com.stackhawk.hste.extension.ascan.ExtensionActiveScan;
import com.stackhawk.hste.extension.ascan.PolicyAllCategoryPanel;
import com.stackhawk.hste.extension.ascan.PolicyCategoryPanel;
import com.stackhawk.hste.extension.ascan.PolicyManagerDialog;
import com.stackhawk.hste.extension.ascan.ScanPolicy;
import com.stackhawk.hste.utils.DisplayUtils;
import java.awt.HeadlessException;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Category;
import org.parosproxy.paros.view.AbstractParamDialog;
import org.parosproxy.paros.view.AbstractParamPanel;

public class PolicyDialog
extends AbstractParamDialog {
    private static final long serialVersionUID = 1L;
    private static final String POLICY = Constant.messages.getString("ascan.policy.dialog.title");
    private static final String[] ROOT = new String[0];
    private ExtensionActiveScan extension;
    private PolicyAllCategoryPanel policyAllCategoryPanel = null;
    private List<AbstractParamPanel> additionalPanels = new ArrayList<AbstractParamPanel>();
    private PolicyManagerDialog pmd;
    private ScanPolicy policy;
    private String currentName;

    public PolicyDialog(ExtensionActiveScan extension, PolicyManagerDialog pmd, ScanPolicy policy) throws HeadlessException {
        super((Window)pmd, true, POLICY, Constant.messages.getString("ascan.policy.title"));
        this.extension = extension;
        this.pmd = pmd;
        this.policy = policy;
        this.currentName = policy.getName();
        this.initialize();
    }

    private void initialize() {
        this.setTitle(POLICY);
        this.setSize(DisplayUtils.getScaledDimension(750, 420));
        this.addParamPanel(null, this.getPolicyAllCategoryPanel(), false);
        for (int i = 0; i < Category.getAllNames().length; ++i) {
            this.addParamPanel(ROOT, Category.getName(i), new PolicyCategoryPanel(i, this.policy.getPluginFactory(), this.policy.getDefaultThreshold()), true);
        }
        this.setFooter(Constant.messages.getString("ascan.policy.dialog.footer"));
    }

    public void addPolicyPanel(AbstractParamPanel panel) {
        this.additionalPanels.add(panel);
        this.addParamPanel(ROOT, panel.getName(), panel, true);
    }

    public PolicyAllCategoryPanel getPolicyAllCategoryPanel() {
        if (this.policyAllCategoryPanel == null) {
            this.policyAllCategoryPanel = new PolicyAllCategoryPanel(this.pmd, this.extension, this.policy);
            this.policyAllCategoryPanel.setName(Constant.messages.getString("ascan.policy.title"));
        }
        return this.policyAllCategoryPanel;
    }

    @Override
    public void saveParam() throws Exception {
        super.saveParam();
        this.extension.getPolicyManager().savePolicy(this.policy, this.currentName);
        this.pmd.policyNamesChanged();
    }
}

