/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.ascan;

import com.stackhawk.hste.extension.ascan.ExtensionActiveScan;
import com.stackhawk.hste.extension.ascan.ScanPolicy;
import com.stackhawk.hste.utils.HsteXmlConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;

public class PolicyManager {
    public static final String POLICY_EXTENSION = ".policy";
    private static final String DEFAULT_POLICY_NAME = Constant.messages.getString("ascan.policymgr.default.name");
    public static final String ILLEGAL_POLICY_NAME_CHRS = "/`?*\\<>|\":\t\n\r";
    private List<String> allPolicyNames = null;
    private ExtensionActiveScan extension;
    private static final Logger LOGGER = LogManager.getLogger(PolicyManager.class);

    public PolicyManager(ExtensionActiveScan extension) {
        this.extension = extension;
    }

    public void init() {
        this.getAllPolicyNames();
    }

    public synchronized List<String> getAllPolicyNames() {
        if (this.allPolicyNames == null) {
            this.allPolicyNames = new ArrayList<String>();
            String[] files = Constant.getPoliciesDir().list();
            if (files != null) {
                for (String file : files) {
                    if (!file.endsWith(POLICY_EXTENSION)) continue;
                    LOGGER.debug("Found policy file {}", (Object)file);
                    this.allPolicyNames.add(file.substring(0, file.lastIndexOf(POLICY_EXTENSION)));
                }
            }
            if (this.allPolicyNames.isEmpty()) {
                ScanPolicy defaultPolicy = new ScanPolicy();
                defaultPolicy.setName(DEFAULT_POLICY_NAME);
                defaultPolicy.getPluginFactory().loadAllPlugin((Configuration)this.extension.getScannerParam().getConfig());
                try {
                    this.savePolicy(defaultPolicy);
                }
                catch (ConfigurationException e) {
                    LOGGER.debug("Failed to create default scan policy in {}", (Object)Constant.getPoliciesDir().getAbsolutePath(), (Object)e);
                }
            }
            Collections.sort(this.allPolicyNames);
        }
        return this.allPolicyNames;
    }

    public void savePolicy(ScanPolicy policy) throws ConfigurationException {
        this.savePolicy(policy, null);
    }

    public void savePolicy(ScanPolicy policy, String previousName) throws ConfigurationException {
        File oldFile;
        LOGGER.debug("Save policy {}", (Object)policy.getName());
        File file = new File(Constant.getPoliciesDir(), policy.getName() + POLICY_EXTENSION);
        HsteXmlConfiguration conf = new HsteXmlConfiguration();
        conf.setProperty("policy", policy.getName());
        conf.setProperty("scanner.level", policy.getDefaultThreshold().name());
        conf.setProperty("scanner.strength", policy.getDefaultStrength().name());
        policy.getPluginFactory().saveTo((Configuration)conf);
        if (previousName != null && !previousName.equals(policy.getName()) && (oldFile = new File(Constant.getPoliciesDir(), previousName + POLICY_EXTENSION)).exists()) {
            oldFile.delete();
        }
        conf.save(file);
        if (previousName != null && previousName.length() > 0) {
            this.allPolicyNames.remove(previousName);
        }
        if (!this.allPolicyNames.contains(policy.getName())) {
            this.allPolicyNames.add(policy.getName());
            Collections.sort(this.allPolicyNames);
        }
    }

    public static boolean policyExists(String name) {
        return new File(Constant.getPoliciesDir(), name + POLICY_EXTENSION).exists();
    }

    public ScanPolicy getPolicy(String name) throws ConfigurationException {
        return this.loadPolicy(new File(Constant.getPoliciesDir(), name + POLICY_EXTENSION));
    }

    public ScanPolicy loadPolicy(String name) throws ConfigurationException {
        return this.loadPolicy(new File(Constant.getPoliciesDir(), name + POLICY_EXTENSION));
    }

    private ScanPolicy loadPolicy(File file) throws ConfigurationException {
        File policyFile;
        try {
            policyFile = file.toPath().toRealPath(new LinkOption[0]).toFile();
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to obtain the real path of the policy file:", (Throwable)e);
        }
        ScanPolicy policy = new ScanPolicy(new HsteXmlConfiguration(policyFile));
        if (!policyFile.getName().equals(policy.getName() + POLICY_EXTENSION)) {
            policy.setName(policyFile.getName().substring(0, policyFile.getName().indexOf(POLICY_EXTENSION)));
        }
        return policy;
    }

    public void importPolicy(File file) throws ConfigurationException, IOException {
        LOGGER.debug("Import policy from {}", (Object)file.getAbsolutePath());
        ScanPolicy policy = new ScanPolicy(new HsteXmlConfiguration(file));
        String baseName = file.getName();
        if (baseName.endsWith(POLICY_EXTENSION)) {
            baseName = baseName.substring(0, baseName.indexOf(POLICY_EXTENSION));
        }
        Object finalName = baseName;
        File newFile = new File(Constant.getPoliciesDir(), (String)finalName + POLICY_EXTENSION);
        int i = 2;
        while (newFile.exists()) {
            finalName = baseName + i;
            newFile = new File(Constant.getPoliciesDir(), (String)finalName + POLICY_EXTENSION);
            ++i;
        }
        policy.setName((String)finalName);
        this.savePolicy(policy);
    }

    public void exportPolicy(ScanPolicy policy, File file) throws ConfigurationException {
        LOGGER.debug("Export policy to {}", (Object)file.getAbsolutePath());
        HsteXmlConfiguration conf = new HsteXmlConfiguration();
        conf.setProperty("policy", policy.getName());
        conf.setProperty("scanner.level", policy.getDefaultThreshold().name());
        conf.setProperty("scanner.strength", policy.getDefaultStrength().name());
        policy.getPluginFactory().saveTo((Configuration)conf);
        conf.save(file);
    }

    public ScanPolicy getTemplatePolicy() throws ConfigurationException {
        return new ScanPolicy();
    }

    public void deletePolicy(String name) {
        LOGGER.debug("Delete policy {}", (Object)name);
        File file = new File(Constant.getPoliciesDir(), name + POLICY_EXTENSION);
        if (file.exists()) {
            file.delete();
        }
        this.allPolicyNames.remove(name);
    }

    public ScanPolicy getDefaultScanPolicy() {
        try {
            String policyName = this.extension.getScannerParam().getDefaultPolicy();
            if (PolicyManager.policyExists(policyName)) {
                LOGGER.debug("getDefaultScanPolicy: {}", (Object)policyName);
                return this.loadPolicy(policyName);
            }
            policyName = DEFAULT_POLICY_NAME;
            if (PolicyManager.policyExists(policyName)) {
                LOGGER.debug("getDefaultScanPolicy (default name): {}", (Object)policyName);
                return this.loadPolicy(policyName);
            }
            if (this.allPolicyNames.size() > 0) {
                LOGGER.debug("getDefaultScanPolicy (first one): {}", (Object)policyName);
                return this.loadPolicy(this.allPolicyNames.get(0));
            }
        }
        catch (ConfigurationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        LOGGER.debug("getDefaultScanPolicy (new blank)");
        return new ScanPolicy();
    }

    public ScanPolicy getAttackScanPolicy() {
        try {
            String policyName = this.extension.getScannerParam().getAttackPolicy();
            if (PolicyManager.policyExists(policyName)) {
                return this.loadPolicy(policyName);
            }
            policyName = DEFAULT_POLICY_NAME;
            if (PolicyManager.policyExists(policyName)) {
                return this.loadPolicy(policyName);
            }
            if (this.allPolicyNames.size() > 0) {
                return this.loadPolicy(this.allPolicyNames.get(0));
            }
        }
        catch (ConfigurationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return new ScanPolicy();
    }

    public boolean isLegalPolicyName(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (ILLEGAL_POLICY_NAME_CHRS.indexOf(str.charAt(i)) < 0) continue;
            return false;
        }
        return true;
    }
}

