/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.ascan;

import com.stackhawk.hste.extension.ascan.ActiveScan;
import com.stackhawk.hste.extension.ascan.ExtensionActiveScan;
import com.stackhawk.hste.extension.ascan.ResponseCountSnapshot;
import com.stackhawk.hste.extension.ascan.ScanProgressActionIcon;
import com.stackhawk.hste.extension.ascan.ScanProgressItem;
import com.stackhawk.hste.extension.ascan.ScanProgressTableModel;
import com.stackhawk.hste.utils.FontUtils;
import com.stackhawk.hste.view.LayoutHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.plaf.basic.core.BasicTransferable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.Layer;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.view.View;

public class ScanProgressDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(ScanProgressDialog.class);
    private ExtensionActiveScan extension;
    private JScrollPane jScrollPane;
    private JTable table;
    private ScanProgressTableModel model;
    private JButton closeButton;
    private JButton copyToClipboardButton;
    private JComboBox<String> hostSelect;
    private ActiveScan scan;
    private boolean stopThread;
    private JFreeChart chart;
    private List<String> labelsAdded = new ArrayList<String>();
    private TimeSeries seriesTotal;
    private TimeSeries series100;
    private TimeSeries series200;
    private TimeSeries series300;
    private TimeSeries series400;
    private TimeSeries series500;
    private double lastCentre = -1.0;

    public ScanProgressDialog(Frame owner, String target, ExtensionActiveScan extension) {
        super(owner, false);
        if (target != null) {
            this.setTitle(Constant.messages.getString("ascan.progress.title", target));
        }
        this.extension = extension;
        this.initialize();
    }

    private void initialize() {
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel tab1 = new JPanel();
        tab1.setLayout(new GridBagLayout());
        JPanel hostPanel = new JPanel();
        hostPanel.setLayout(new GridBagLayout());
        hostPanel.add((Component)new JLabel(Constant.messages.getString("ascan.progress.label.host")), LayoutHelper.getGBC(0, 0, 1, 0.4));
        hostPanel.add(this.getHostSelect(), LayoutHelper.getGBC(1, 0, 1, 0.6));
        tab1.add((Component)hostPanel, LayoutHelper.getGBC(0, 0, 3, 1.0, 0.0));
        tab1.add((Component)this.getJScrollPane(), LayoutHelper.getGBC(0, 1, 3, 1.0, 1.0));
        JPanel buttonsPanel = new JPanel(new FlowLayout(1, 5, 0));
        buttonsPanel.add(this.getCopyToClipboardButton());
        buttonsPanel.add(this.getCloseButton());
        tab1.add((Component)buttonsPanel, LayoutHelper.getGBC(0, 2, 3, 1.0));
        tabbedPane.insertTab(Constant.messages.getString("ascan.progress.tab.progress"), null, tab1, null, 0);
        this.add(tabbedPane);
        int mins = this.extension.getScannerParam().getMaxChartTimeInMins();
        if (mins > 0) {
            JPanel tab2 = new JPanel();
            tab2.setLayout(new GridBagLayout());
            this.seriesTotal = new TimeSeries((Comparable)((Object)"TotalResponses"));
            TimeSeriesCollection dataset = new TimeSeriesCollection(this.seriesTotal);
            this.series100 = new TimeSeries((Comparable)((Object)Constant.messages.getString("ascan.progress.chart.1xx")));
            this.series200 = new TimeSeries((Comparable)((Object)Constant.messages.getString("ascan.progress.chart.2xx")));
            this.series300 = new TimeSeries((Comparable)((Object)Constant.messages.getString("ascan.progress.chart.3xx")));
            this.series400 = new TimeSeries((Comparable)((Object)Constant.messages.getString("ascan.progress.chart.4xx")));
            this.series500 = new TimeSeries((Comparable)((Object)Constant.messages.getString("ascan.progress.chart.5xx")));
            long maxAge = (long)mins * 60L;
            this.seriesTotal.setMaximumItemAge(maxAge);
            this.series100.setMaximumItemAge(maxAge);
            this.series200.setMaximumItemAge(maxAge);
            this.series300.setMaximumItemAge(maxAge);
            this.series400.setMaximumItemAge(maxAge);
            this.series500.setMaximumItemAge(maxAge);
            dataset.addSeries(this.series100);
            dataset.addSeries(this.series200);
            dataset.addSeries(this.series300);
            dataset.addSeries(this.series400);
            dataset.addSeries(this.series500);
            this.chart = this.createChart((XYDataset)dataset);
            this.chart.getXYPlot().getRenderer(0).setSeriesPaint(0, (Paint)Color.BLACK);
            this.chart.getXYPlot().getRenderer(0).setSeriesPaint(1, (Paint)Color.GRAY);
            this.chart.getXYPlot().getRenderer(0).setSeriesPaint(2, (Paint)Color.GREEN);
            this.chart.getXYPlot().getRenderer(0).setSeriesPaint(3, (Paint)Color.BLUE);
            this.chart.getXYPlot().getRenderer(0).setSeriesPaint(4, (Paint)Color.MAGENTA);
            this.chart.getXYPlot().getRenderer(0).setSeriesPaint(5, (Paint)Color.RED);
            ChartPanel chartPanel = new ChartPanel(this.chart);
            tab2.add((Component)chartPanel, LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0));
            tabbedPane.insertTab(Constant.messages.getString("ascan.progress.tab.chart"), null, tab2, null, 1);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ScanProgressDialog.this.stopThread = true;
            }
        });
        this.pack();
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart result = ChartFactory.createTimeSeriesChart(null, (String)Constant.messages.getString("ascan.progress.chart.time"), (String)Constant.messages.getString("ascan.progress.chart.responses"), (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = result.getXYPlot();
        ValueAxis daxis = plot.getDomainAxis();
        daxis.setAutoRange(true);
        daxis.setAutoRangeMinimumSize(60000.0);
        plot.getRangeAxis().setAutoRangeMinimumSize(20.0);
        return result;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getMainPanel());
            this.jScrollPane.setName("ScanProgressScrollPane");
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setVerticalScrollBarPolicy(20);
        }
        return this.jScrollPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton(Constant.messages.getString("all.button.close"));
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScanProgressDialog.this.dispatchEvent(new WindowEvent(ScanProgressDialog.this, 201));
                }
            });
        }
        return this.closeButton;
    }

    private JButton getCopyToClipboardButton() {
        if (this.copyToClipboardButton == null) {
            this.copyToClipboardButton = new JButton(Constant.messages.getString("ascan.progress.copyclipboard.button.label"));
            this.copyToClipboardButton.setToolTipText(Constant.messages.getString("ascan.progress.copyclipboard.button.tooltip"));
            this.copyToClipboardButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StringBuilder plainContent = new StringBuilder();
                    StringBuilder htmlContent = new StringBuilder();
                    htmlContent.append("<html>\n<body>\n<table>\n");
                    TableModel tableModel = ScanProgressDialog.this.getMainPanel().getModel();
                    htmlContent.append("<tr>\n");
                    for (int col = 0; col < tableModel.getColumnCount(); ++col) {
                        String val = tableModel.getColumnName(col);
                        plainContent.append(val).append('\t');
                        htmlContent.append("  <td>").append(val).append("</td>\n");
                    }
                    plainContent.deleteCharAt(plainContent.length() - 1).append("\n");
                    htmlContent.append("</tr>\n");
                    for (int row = 0; row < tableModel.getRowCount(); ++row) {
                        htmlContent.append("<tr>\n");
                        for (int col = 0; col < tableModel.getColumnCount(); ++col) {
                            Object obj = tableModel.getValueAt(row, col);
                            String val = obj == null ? "" : obj.toString();
                            plainContent.append(val).append('\t');
                            htmlContent.append("  <td>").append(val).append("</td>\n");
                        }
                        plainContent.deleteCharAt(plainContent.length() - 1).append("\n");
                        htmlContent.append("</tr>\n");
                    }
                    plainContent.deleteCharAt(plainContent.length() - 1);
                    htmlContent.append("</table>\n</body>\n</html>");
                    BasicTransferable transferable = new BasicTransferable(plainContent.toString(), htmlContent.toString());
                    try {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)transferable, null);
                    }
                    catch (IllegalStateException e) {
                        View.getSingleton().showWarningDialog((Window)ScanProgressDialog.this, Constant.messages.getString("ascan.progress.copyclipboard.error"));
                        LOGGER.warn("Failed to copy the contents to clipboard:", (Throwable)e);
                    }
                }
            });
        }
        return this.copyToClipboardButton;
    }

    private JTable getMainPanel() {
        if (this.table == null) {
            this.model = new ScanProgressTableModel();
            this.table = new JTable();
            this.table.setModel(this.model);
            this.table.setRowSelectionAllowed(false);
            this.table.setColumnSelectionAllowed(false);
            this.table.setDoubleBuffered(true);
            this.table.getColumnModel().getColumn(0).setPreferredWidth(256);
            this.table.getColumnModel().getColumn(1).setPreferredWidth(80);
            this.table.getColumnModel().getColumn(2).setPreferredWidth(80);
            this.table.getColumnModel().getColumn(2).setCellRenderer(new ScanProgressBarRenderer());
            DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
            centerRenderer.setHorizontalAlignment(0);
            this.table.getColumnModel().getColumn(3).setPreferredWidth(85);
            this.table.getColumnModel().getColumn(3).setCellRenderer(centerRenderer);
            DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
            rightRenderer.setHorizontalAlignment(4);
            this.table.getColumnModel().getColumn(4).setPreferredWidth(60);
            this.table.getColumnModel().getColumn(4).setCellRenderer(rightRenderer);
            this.table.getColumnModel().getColumn(5).setPreferredWidth(60);
            this.table.getColumnModel().getColumn(5).setCellRenderer(rightRenderer);
            this.table.getColumnModel().getColumn(6).setPreferredWidth(40);
            this.table.getColumnModel().getColumn(6).setCellRenderer(new ScanProgressActionRenderer());
            ScanProgressActionListener listener = new ScanProgressActionListener(this.table, this.model);
            this.table.addMouseListener(listener);
            this.table.addMouseMotionListener(listener);
        }
        return this.table;
    }

    private void updateProgress() {
        HostProcess hp = this.getSelectedHostProcess();
        if (this.scan.getHostProcesses() != null && hp != null) {
            this.model.updateValues(this.scan, hp);
            if (this.scan.isStopped()) {
                this.stopThread = true;
            }
            if (this.chart != null) {
                ResponseCountSnapshot snapshot = this.scan.getRequestHistory();
                while (snapshot != null) {
                    try {
                        Second second = new Second(snapshot.getDate());
                        this.seriesTotal.add((RegularTimePeriod)second, (double)snapshot.getTotal());
                        this.series100.add((RegularTimePeriod)second, (double)snapshot.getResp100());
                        this.series200.add((RegularTimePeriod)second, (double)snapshot.getResp200());
                        this.series300.add((RegularTimePeriod)second, (double)snapshot.getResp300());
                        this.series400.add((RegularTimePeriod)second, (double)snapshot.getResp400());
                        this.series500.add((RegularTimePeriod)second, (double)snapshot.getResp500());
                        snapshot = this.scan.getRequestHistory();
                        for (Plugin plugin : this.scan.getHostProcesses().get(0).getRunning()) {
                            if (this.labelsAdded.contains(plugin.getName())) continue;
                            ValueMarker vm = new ValueMarker((double)plugin.getTimeStarted().getTime());
                            double center = this.chart.getXYPlot().getRangeAxis().getRange().getCentralValue();
                            if (this.lastCentre != center) {
                                if (this.lastCentre != -1.0) {
                                    List annotations = this.chart.getXYPlot().getAnnotations();
                                    for (Object o : annotations) {
                                        if (!(o instanceof XYTextAnnotation)) continue;
                                        XYTextAnnotation annotation = (XYTextAnnotation)o;
                                        annotation.setY(center);
                                    }
                                }
                                this.lastCentre = center;
                            }
                            XYTextAnnotation updateLabel = new XYTextAnnotation(plugin.getName(), (double)plugin.getTimeStarted().getTime(), center);
                            updateLabel.setFont(FontUtils.getFont("Sans Serif"));
                            updateLabel.setRotationAnchor(TextAnchor.BASELINE_CENTER);
                            updateLabel.setTextAnchor(TextAnchor.BASELINE_CENTER);
                            updateLabel.setRotationAngle(-1.57);
                            updateLabel.setPaint((Paint)Color.black);
                            this.chart.getXYPlot().addDomainMarker((Marker)vm, Layer.BACKGROUND);
                            this.chart.getXYPlot().addAnnotation((XYAnnotation)updateLabel);
                            this.labelsAdded.add(plugin.getName());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        snapshot = null;
                    }
                }
            }
        }
    }

    private HostProcess getSelectedHostProcess() {
        String str = (String)this.getHostSelect().getSelectedItem();
        if (str == null) {
            return null;
        }
        for (HostProcess hp : this.scan.getHostProcesses()) {
            if (!str.equals(hp.getHostAndPort())) continue;
            return hp;
        }
        return null;
    }

    public void setActiveScan(ActiveScan scan) {
        this.scan = scan;
        if (scan == null) {
            return;
        }
        this.getHostSelect().removeAll();
        for (HostProcess hp : scan.getHostProcesses()) {
            this.getHostSelect().addItem(hp.getHostAndPort());
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (!ScanProgressDialog.this.stopThread) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ScanProgressDialog.this.updateProgress();
                        }
                    });
                    try {
                        4.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        thread.start();
    }

    private JComboBox<String> getHostSelect() {
        if (this.hostSelect == null) {
            this.hostSelect = new JComboBox();
            this.hostSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScanProgressDialog.this.updateProgress();
                }
            });
        }
        return this.hostSelect;
    }

    private static class ScanProgressBarRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private ScanProgressBarRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                ScanProgressItem item = (ScanProgressItem)value;
                JProgressBar bar = new JProgressBar();
                bar.setMaximum(100);
                bar.setValue(item.getProgressPercentage());
                return bar;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class ScanProgressActionRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private ScanProgressActionRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                ScanProgressActionIcon action = (ScanProgressActionIcon)value;
                if (action == ScanProgressDialog.this.model.getFocusedAction()) {
                    action.setOver();
                } else {
                    action.setNormal();
                }
                action.setOpaque(true);
                action.setBackground(this.getBackground());
                return action;
            }
            return this;
        }
    }

    private static class ScanProgressActionListener
    extends MouseAdapter {
        private static final int NOT_FOUND = -1;
        private final JTable table;
        private final ScanProgressTableModel model;

        public ScanProgressActionListener(JTable table, ScanProgressTableModel model) {
            this.table = table;
            this.model = model;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ScanProgressActionIcon action = this.getScanProgressAction(e.getPoint());
            if (action != null) {
                action.invokeAction();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ScanProgressActionIcon action = this.getScanProgressAction(e.getPoint());
            if (action != null) {
                action.setPressed();
                action.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ScanProgressActionIcon action = this.getScanProgressAction(e.getPoint());
            if (action != null) {
                action.setReleased();
                action.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            ScanProgressActionIcon action = this.getScanProgressAction(me.getPoint());
            if (action != null) {
                this.model.setFocusedAction(action);
                action.repaint();
            } else if (this.model.getFocusedAction() != null) {
                this.model.setFocusedAction(action);
                this.table.repaint();
            }
        }

        private ScanProgressActionIcon getScanProgressAction(Point point) {
            int column = this.table.columnAtPoint(point);
            if (column == -1) {
                return null;
            }
            int row = this.table.rowAtPoint(point);
            if (row == -1) {
                return null;
            }
            Object value = this.table.getValueAt(row, column);
            if (value instanceof ScanProgressActionIcon) {
                return (ScanProgressActionIcon)value;
            }
            return null;
        }
    }
}

