/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.ascan;

import com.stackhawk.hste.extension.ascan.ScanProgressActionIcon;
import java.util.Date;
import java.util.Locale;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginStats;

public class ScanProgressItem {
    public static final int STATUS_PENDING = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_COMPLETED = 3;
    private HostProcess hProcess;
    private Plugin plugin;
    private int status;
    private ScanProgressActionIcon progressAction;
    private final PluginStats pluginStats;

    public ScanProgressItem(HostProcess hProcess, Plugin plugin, int status) {
        this.hProcess = hProcess;
        this.plugin = plugin;
        this.pluginStats = hProcess.getPluginStats(plugin.getId());
        this.status = status;
        this.progressAction = new ScanProgressActionIcon(this);
    }

    public String getNameLabel() {
        return this.pluginStats.getPluginName();
    }

    @Deprecated
    public String getAttackStrenghtLabel() {
        return this.getAttackStrengthLabel();
    }

    public String getAttackStrengthLabel() {
        return Constant.messages.getString("ascan.policy.level." + this.plugin.getAttackStrength().name().toLowerCase(Locale.ROOT));
    }

    public String getStatusLabel() {
        switch (this.status) {
            case 3: {
                return Constant.messages.getString("ascan.progress.label.completed");
            }
            case 2: {
                return Constant.messages.getString("ascan.progress.label.running");
            }
            case 1: {
                return Constant.messages.getString("ascan.progress.label.pending");
            }
        }
        return "";
    }

    public long getElapsedTime() {
        if (this.status == 1 || this.plugin.getTimeStarted() == null) {
            return -1L;
        }
        Date end = this.plugin.getTimeFinished() == null ? new Date() : this.plugin.getTimeFinished();
        return end.getTime() - this.plugin.getTimeStarted().getTime();
    }

    public int getProgressPercentage() {
        if (this.isRunning()) {
            int progress = this.hProcess.getTestCurrentCount(this.plugin) * 100 / this.hProcess.getTestTotalCount();
            return progress >= 100 ? 99 : progress;
        }
        if (this.isCompleted() || this.isSkipped()) {
            return 100;
        }
        return 0;
    }

    ScanProgressActionIcon getProgressAction() {
        return this.progressAction;
    }

    public boolean isRunning() {
        return this.status == 2;
    }

    boolean isPending() {
        return this.status == 1;
    }

    public boolean isCompleted() {
        return this.status == 3;
    }

    public boolean isSkipped() {
        return this.pluginStats.isSkipped();
    }

    public String getSkippedReason() {
        return this.pluginStats.getSkippedReason();
    }

    public void skip() {
        if (!this.isCompleted() && !this.isStopped()) {
            this.hProcess.pluginSkipped(this.plugin, Constant.messages.getString("ascan.progress.label.skipped.reason.user"));
        }
    }

    protected Plugin getPlugin() {
        return this.plugin;
    }

    public int getReqCount() {
        return this.pluginStats.getMessageCount();
    }

    int getAlertCount() {
        return this.pluginStats.getAlertCount();
    }

    public String toString() {
        return Integer.toString(this.getProgressPercentage());
    }

    void refresh() {
        if (this.isCompleted()) {
            return;
        }
        if (this.hProcess.getCompleted().contains(this.plugin)) {
            this.status = 3;
        } else if (this.hProcess.getRunning().contains(this.plugin)) {
            this.status = 2;
        }
    }

    boolean isStopped() {
        return this.hProcess.isStop();
    }
}

