/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.ascan;

import com.stackhawk.hste.extension.ascan.ActiveScan;
import com.stackhawk.hste.extension.ascan.ScanProgressActionIcon;
import com.stackhawk.hste.extension.ascan.ScanProgressItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Plugin;

public class ScanProgressTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{"", Constant.messages.getString("ascan.policy.table.strength"), Constant.messages.getString("ascan.progress.table.progress"), Constant.messages.getString("ascan.progress.table.time"), Constant.messages.getString("ascan.progress.table.reqs"), Constant.messages.getString("ascan.progress.table.alerts"), Constant.messages.getString("ascan.progress.table.status")};
    private HostProcess hp;
    private List<ScanProgressItem> values = new ArrayList<ScanProgressItem>();
    private ScanProgressActionIcon focusedAction = null;
    private String totRequests;
    private String totTime;

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.size() + 5;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row == 0) {
            switch (col) {
                case 0: {
                    return Constant.messages.getString("ascan.progress.table.analyser");
                }
                case 3: {
                    return this.hp != null ? this.getElapsedTimeLabel(this.hp.getAnalyser().getRunningTime()) : "";
                }
                case 4: {
                    return this.hp != null ? String.valueOf(this.hp.getAnalyser().getRequestCount()) : "";
                }
            }
            return null;
        }
        if (row == 1) {
            return null;
        }
        if (row == 2) {
            return col == 0 ? Constant.messages.getString("ascan.progress.table.name") : null;
        }
        if ((row -= 3) < this.values.size()) {
            ScanProgressItem item = this.values.get(row);
            switch (col) {
                case 0: {
                    return item.getNameLabel();
                }
                case 1: {
                    return item.getAttackStrengthLabel();
                }
                case 2: {
                    if (item.isCompleted() || item.isRunning() || item.isSkipped()) {
                        return item;
                    }
                    return null;
                }
                case 3: {
                    return this.getElapsedTimeLabel(item.getElapsedTime());
                }
                case 4: {
                    return item.getReqCount();
                }
                case 5: {
                    return item.getAlertCount();
                }
                case 6: {
                    return item.getProgressAction();
                }
            }
            return null;
        }
        if (row == this.values.size()) {
            return null;
        }
        if (row == this.values.size() + 1) {
            switch (col) {
                case 0: {
                    return Constant.messages.getString("ascan.progress.label.totals");
                }
                case 3: {
                    return this.totTime;
                }
                case 4: {
                    return this.totRequests;
                }
                case 5: {
                    return this.hp != null ? this.hp.getAlertCount() : 0;
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Class<?> getColumnClass(int c) {
        switch (c) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return ScanProgressItem.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return ScanProgressActionIcon.class;
            }
        }
        return null;
    }

    public List<ScanProgressItem> getValues() {
        return this.values;
    }

    public void setFocusedAction(ScanProgressActionIcon actionIcon) {
        this.focusedAction = actionIcon;
    }

    public ScanProgressActionIcon getFocusedAction() {
        return this.focusedAction;
    }

    public void updateValues(ActiveScan scan, HostProcess hp) {
        this.setHostProcess(hp);
        Date end = scan.getTimeFinished() == null ? new Date() : scan.getTimeFinished();
        long elapsed = end.getTime() - scan.getTimeStarted().getTime();
        this.totTime = this.getElapsedTimeLabel(elapsed);
        this.totRequests = Integer.toString(scan.getTotalRequests());
        this.fireTableDataChanged();
    }

    private void setHostProcess(HostProcess hp) {
        if (this.hp == hp) {
            for (ScanProgressItem spi : this.values) {
                spi.refresh();
            }
            return;
        }
        this.hp = hp;
        this.values.clear();
        for (Plugin plugin : hp.getCompleted()) {
            this.values.add(new ScanProgressItem(hp, plugin, 3));
        }
        for (Plugin plugin : hp.getRunning()) {
            this.values.add(new ScanProgressItem(hp, plugin, 2));
        }
        for (Plugin plugin : hp.getPending()) {
            this.values.add(new ScanProgressItem(hp, plugin, 1));
        }
    }

    private String getElapsedTimeLabel(long elapsed) {
        return elapsed >= 0L ? String.format("%02d:%02d.%03d", elapsed / 60000L, elapsed % 60000L / 1000L, elapsed % 1000L) : null;
    }
}

