/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.authentication;

import com.stackhawk.hste.authentication.AbstractAuthenticationMethodOptionsPanel;
import com.stackhawk.hste.authentication.AuthenticationIndicatorsPanel;
import com.stackhawk.hste.authentication.AuthenticationMethod;
import com.stackhawk.hste.authentication.AuthenticationMethodType;
import com.stackhawk.hste.extension.authentication.ExtensionAuthentication;
import com.stackhawk.hste.extension.users.ExtensionUserManagement;
import com.stackhawk.hste.model.Context;
import com.stackhawk.hste.users.User;
import com.stackhawk.hste.utils.FontUtils;
import com.stackhawk.hste.utils.HsteHtmlLabel;
import com.stackhawk.hste.utils.HsteNumberSpinner;
import com.stackhawk.hste.utils.HsteTextArea;
import com.stackhawk.hste.utils.HsteTextField;
import com.stackhawk.hste.view.AbstractContextPropertiesPanel;
import com.stackhawk.hste.view.LayoutHelper;
import com.stackhawk.hste.view.NodeSelectDialog;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.border.EmptyBorder;
import org.apache.commons.httpclient.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;

public class ContextAuthenticationPanel
extends AbstractContextPropertiesPanel {
    private static final Logger LOGGER = LogManager.getLogger(ContextAuthenticationPanel.class);
    private static final long serialVersionUID = -898084998156067286L;
    private static final String PANEL_NAME = Constant.messages.getString("authentication.panel.title");
    private static final String FIELD_LABEL_LOGGED_IN_INDICATOR = Constant.messages.getString("authentication.panel.label.loggedIn");
    private static final String FIELD_LABEL_LOGGED_OUT_INDICATOR = Constant.messages.getString("authentication.panel.label.loggedOut");
    private static final String FIELD_LABEL_TYPE_SELECT = Constant.messages.getString("authentication.panel.label.typeSelect");
    private static final String LABEL_DESCRIPTION = Constant.messages.getString("authentication.panel.label.description");
    private static final String PANEL_TITLE_CONFIG = Constant.messages.getString("authentication.panel.label.configTitle");
    private static final String PANEL_TITLE_VERIF = Constant.messages.getString("authentication.panel.label.verifTitle");
    private static final String LABEL_POLL_URL = Constant.messages.getString("authentication.panel.label.pollurl");
    private static final String LABEL_POLL_DATA = Constant.messages.getString("authentication.panel.label.polldata");
    private static final String LABEL_POLL_HEADERS = Constant.messages.getString("authentication.panel.label.pollheaders");
    private static final String LABEL_POLL_FREQUENCY = Constant.messages.getString("authentication.panel.label.freq");
    private static final String LABEL_CONFIG_NOT_NEEDED = Constant.messages.getString("sessionmanagement.panel.label.noConfigPanel");
    private static final String LABEL_STRATEGY = Constant.messages.getString("authentication.panel.label.strategy");
    private static final String STRATEGY_PREFIX = "authentication.panel.label.strategy.";
    private static final String FREQUENCY_UNITS_PREFIX = "authentication.panel.label.units.";
    private ExtensionAuthentication extension;
    private JComboBox<AuthenticationMethodType> authenticationMethodsComboBox;
    private AuthenticationMethod selectedAuthenticationMethod;
    private AuthenticationMethodType shownMethodType;
    private AbstractAuthenticationMethodOptionsPanel shownConfigPanel;
    private JPanel configContainerPanel;
    private JPanel verifContainerPanel;
    private JComboBox<AuthCheckingStrategyType> authenticationVerifComboBox;
    private JComboBox<AuthPollFrequencyUnitsType> authFrequencyUnitsComboBox;
    private JButton pollUrlSelectButton = null;
    private HsteTextField pollUrlField = null;
    private HsteTextField pollDataField = null;
    private HsteTextArea pollHeadersField = null;
    private HsteNumberSpinner pollFrequency = null;
    private HsteTextField loggedInIndicatorRegexField = null;
    private HsteTextField loggedOutIndicatorRegexField = null;
    private boolean needsConfirm = true;
    private AuthenticationIndicatorsPanel authenticationIndicatorsPanel;

    public ContextAuthenticationPanel(ExtensionAuthentication extension, Context context) {
        super(context.getId());
        this.extension = extension;
        this.initialize();
    }

    public static String buildName(int contextId) {
        return contextId + ": " + PANEL_NAME;
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(ContextAuthenticationPanel.buildName(this.getContextId()));
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setLayout(new CardLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setPreferredSize(new Dimension(400, 800));
        JScrollPane scrollPanel = new JScrollPane();
        scrollPanel.setHorizontalScrollBarPolicy(31);
        scrollPanel.setVerticalScrollBarPolicy(20);
        scrollPanel.setViewportView(panel);
        this.add(scrollPanel);
        panel.add((Component)new HsteHtmlLabel(LABEL_DESCRIPTION), LayoutHelper.getGBC(0, 0, 1, 1.0));
        panel.add((Component)new JLabel(FIELD_LABEL_TYPE_SELECT), LayoutHelper.getGBC(0, 1, 1, 1.0, new Insets(20, 0, 5, 5)));
        panel.add(this.getAuthenticationMethodsComboBox(), LayoutHelper.getGBC(0, 2, 1, 1.0));
        panel.add((Component)this.getConfigContainerPanel(), LayoutHelper.getGBC(0, 3, 1, 1.0, new Insets(10, 0, 10, 0)));
        panel.add((Component)this.getVerifContainerPanel(), LayoutHelper.getGBC(0, 4, 1, 1.0, new Insets(10, 0, 10, 0)));
        int y = 0;
        int fullWidth = 3;
        this.getVerifContainerPanel().add((Component)new JLabel(LABEL_STRATEGY), LayoutHelper.getGBC(0, y++, fullWidth, 1.0));
        this.getVerifContainerPanel().add(this.getAuthenticationVerifComboBox(), LayoutHelper.getGBC(0, y++, fullWidth, 1.0));
        this.getVerifContainerPanel().add((Component)new JLabel(FIELD_LABEL_LOGGED_IN_INDICATOR), LayoutHelper.getGBC(0, y++, fullWidth, 1.0));
        this.getVerifContainerPanel().add((Component)this.getLoggedInIndicatorRegexField(), LayoutHelper.getGBC(0, y++, fullWidth, 1.0));
        this.getVerifContainerPanel().add((Component)new JLabel(FIELD_LABEL_LOGGED_OUT_INDICATOR), LayoutHelper.getGBC(0, y++, fullWidth, 1.0));
        this.getVerifContainerPanel().add((Component)this.getLoggedOutIndicatorRegexField(), LayoutHelper.getGBC(0, y++, fullWidth, 1.0));
        this.getVerifContainerPanel().add((Component)new JLabel(LABEL_POLL_FREQUENCY), LayoutHelper.getGBC(0, y, 1, 0.34));
        this.getVerifContainerPanel().add((Component)this.getPollFrequencySpinner(), LayoutHelper.getGBC(1, y, 1, 0.33));
        this.getVerifContainerPanel().add(this.getAuthFrequencyUnitsComboBox(), LayoutHelper.getGBC(2, y++, 1, 0.33));
        this.getVerifContainerPanel().add((Component)new JLabel(LABEL_POLL_URL), LayoutHelper.getGBC(0, y++, fullWidth, 1.0));
        JPanel urlPanel = new JPanel(new GridBagLayout());
        urlPanel.add((Component)this.getPollUrlField(), LayoutHelper.getGBC(0, 0, 1, 1.0));
        urlPanel.add((Component)this.getPollUrlSelectButton(), LayoutHelper.getGBC(1, 0, 1, 0.0));
        this.getVerifContainerPanel().add((Component)urlPanel, LayoutHelper.getGBC(0, y++, fullWidth, 1.0));
        this.getVerifContainerPanel().add((Component)new JLabel(LABEL_POLL_DATA), LayoutHelper.getGBC(0, y++, fullWidth, 1.0));
        this.getVerifContainerPanel().add((Component)this.getPollDataField(), LayoutHelper.getGBC(0, y++, fullWidth, 1.0));
        this.getVerifContainerPanel().add((Component)new JLabel(LABEL_POLL_HEADERS), LayoutHelper.getGBC(0, y++, fullWidth, 1.0));
        this.getVerifContainerPanel().add((Component)this.getPollHeadersField(), LayoutHelper.getGBC(0, y++, fullWidth, 1.0));
        panel.add((Component)new JLabel(), LayoutHelper.getGBC(0, 99, 1, 1.0, 1.0));
    }

    private void changeMethodConfigPanel(AuthenticationMethodType newMethodType) {
        if (newMethodType == null) {
            this.getConfigContainerPanel().removeAll();
            this.getConfigContainerPanel().setVisible(false);
            this.shownMethodType = null;
            return;
        }
        if (this.shownMethodType != null && newMethodType.getClass().equals(this.shownMethodType.getClass())) {
            return;
        }
        LOGGER.debug("Creating new panel for configuring: {}", (Object)newMethodType.getName());
        this.getConfigContainerPanel().removeAll();
        if (newMethodType.hasOptionsPanel()) {
            this.shownConfigPanel = newMethodType.buildOptionsPanel(this.getUISharedContext());
            this.getConfigContainerPanel().add((Component)this.shownConfigPanel, "Center");
        } else {
            this.shownConfigPanel = null;
            this.getConfigContainerPanel().add((Component)new HsteHtmlLabel(LABEL_CONFIG_NOT_NEEDED), "Center");
        }
        this.shownMethodType = newMethodType;
        this.getConfigContainerPanel().setVisible(true);
        this.getConfigContainerPanel().revalidate();
    }

    protected JComboBox<AuthenticationMethodType> getAuthenticationMethodsComboBox() {
        if (this.authenticationMethodsComboBox == null) {
            Vector<AuthenticationMethodType> methods = new Vector<AuthenticationMethodType>(this.extension.getAuthenticationMethodTypes());
            this.authenticationMethodsComboBox = new JComboBox<AuthenticationMethodType>(methods);
            this.authenticationMethodsComboBox.setSelectedItem(null);
            this.authenticationMethodsComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && !e.getItem().equals(ContextAuthenticationPanel.this.shownMethodType)) {
                        LOGGER.debug("Selected new Authentication type: {}", e.getItem());
                        AuthenticationMethodType type = (AuthenticationMethodType)e.getItem();
                        if ((ContextAuthenticationPanel.this.shownMethodType == null || type.getAuthenticationCredentialsType() != ContextAuthenticationPanel.this.shownMethodType.getAuthenticationCredentialsType()) && ContextAuthenticationPanel.this.needsConfirm && !ContextAuthenticationPanel.this.confirmAndResetUsersCredentials(type)) {
                            LOGGER.debug("Cancelled change of authentication type.");
                            ContextAuthenticationPanel.this.authenticationMethodsComboBox.setSelectedItem(ContextAuthenticationPanel.this.shownMethodType);
                            return;
                        }
                        ContextAuthenticationPanel.this.resetLoggedInOutIndicators();
                        if (ContextAuthenticationPanel.this.selectedAuthenticationMethod == null || !type.isTypeForMethod(ContextAuthenticationPanel.this.selectedAuthenticationMethod)) {
                            ContextAuthenticationPanel.this.selectedAuthenticationMethod = type.createAuthenticationMethod(ContextAuthenticationPanel.this.getContextId());
                        }
                        ContextAuthenticationPanel.this.changeMethodConfigPanel(type);
                        if (type.hasOptionsPanel()) {
                            ContextAuthenticationPanel.this.shownConfigPanel.bindMethod(ContextAuthenticationPanel.this.selectedAuthenticationMethod, ContextAuthenticationPanel.this.getAuthenticationIndicatorsPanel());
                        }
                    }
                }
            });
        }
        return this.authenticationMethodsComboBox;
    }

    private JComboBox<AuthCheckingStrategyType> getAuthenticationVerifComboBox() {
        if (this.authenticationVerifComboBox == null) {
            this.authenticationVerifComboBox = new JComboBox();
            for (AuthCheckingStrategyType acst : AuthCheckingStrategyType.getAllValues()) {
                this.authenticationVerifComboBox.addItem(acst);
            }
            this.authenticationVerifComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && !e.getItem().equals(ContextAuthenticationPanel.this.shownMethodType)) {
                        ContextAuthenticationPanel.this.setPollFieldStatuses((AuthCheckingStrategyType)e.getItem());
                    }
                }
            });
        }
        return this.authenticationVerifComboBox;
    }

    private void setPollFieldStatuses(AuthCheckingStrategyType type) {
        boolean isPoll = type.getStrategy().equals((Object)AuthenticationMethod.AuthCheckingStrategy.POLL_URL);
        this.getAuthFrequencyUnitsComboBox().setEnabled(isPoll);
        this.getPollFrequencySpinner().setEnabled(isPoll);
        this.getPollUrlSelectButton().setEnabled(isPoll);
        this.getPollUrlField().setEnabled(isPoll);
        this.getPollDataField().setEnabled(isPoll);
        this.getPollHeadersField().setEnabled(isPoll);
        boolean isAutoDetect = type.getStrategy().equals((Object)AuthenticationMethod.AuthCheckingStrategy.AUTO_DETECT);
        this.getLoggedInIndicatorRegexField().setEnabled(!isAutoDetect);
        this.getLoggedOutIndicatorRegexField().setEnabled(!isAutoDetect);
    }

    private JComboBox<AuthPollFrequencyUnitsType> getAuthFrequencyUnitsComboBox() {
        if (this.authFrequencyUnitsComboBox == null) {
            this.authFrequencyUnitsComboBox = new JComboBox();
            for (AuthPollFrequencyUnitsType acst : AuthPollFrequencyUnitsType.getAllValues()) {
                this.authFrequencyUnitsComboBox.addItem(acst);
            }
        }
        return this.authFrequencyUnitsComboBox;
    }

    private HsteNumberSpinner getPollFrequencySpinner() {
        if (this.pollFrequency == null) {
            this.pollFrequency = new HsteNumberSpinner(1, 60, Integer.MAX_VALUE);
            JComponent mySpinnerEditor = this.pollFrequency.getEditor();
            JFormattedTextField jftf = ((JSpinner.DefaultEditor)mySpinnerEditor).getTextField();
            jftf.setColumns(6);
        }
        return this.pollFrequency;
    }

    private AuthenticationIndicatorsPanel getAuthenticationIndicatorsPanel() {
        if (this.authenticationIndicatorsPanel == null) {
            this.authenticationIndicatorsPanel = new AuthenticationIndicatorsPanelImpl();
        }
        return this.authenticationIndicatorsPanel;
    }

    private boolean confirmAndResetUsersCredentials(AuthenticationMethodType type) {
        ExtensionUserManagement usersExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
        if (usersExtension == null) {
            return true;
        }
        List<User> users = usersExtension.getSharedContextUsers(this.getUISharedContext());
        if (users.isEmpty()) {
            return true;
        }
        if (users.stream().anyMatch(user -> user.getAuthenticationCredentials().isConfigured())) {
            this.authenticationMethodsComboBox.transferFocus();
            int choice = JOptionPane.showConfirmDialog(this, Constant.messages.getString("authentication.dialog.confirmChange.label"), Constant.messages.getString("authentication.dialog.confirmChange.title"), 2);
            if (choice == 2) {
                return false;
            }
        }
        users.replaceAll(user -> {
            User modifiedUser = new User(user.getContextId(), user.getName(), user.getId());
            modifiedUser.setEnabled(false);
            modifiedUser.setAuthenticationCredentials(type.createAuthenticationCredentials());
            return modifiedUser;
        });
        return true;
    }

    private JPanel getConfigContainerPanel() {
        if (this.configContainerPanel == null) {
            this.configContainerPanel = new JPanel(new BorderLayout());
            this.configContainerPanel.setBorder(BorderFactory.createTitledBorder(null, PANEL_TITLE_CONFIG, 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
        }
        return this.configContainerPanel;
    }

    private JPanel getVerifContainerPanel() {
        if (this.verifContainerPanel == null) {
            this.verifContainerPanel = new JPanel(new GridBagLayout());
            this.verifContainerPanel.setBorder(BorderFactory.createTitledBorder(null, PANEL_TITLE_VERIF, 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
        }
        return this.verifContainerPanel;
    }

    private JButton getPollUrlSelectButton() {
        if (this.pollUrlSelectButton == null) {
            this.pollUrlSelectButton = new JButton(Constant.messages.getString("all.button.select"));
            this.pollUrlSelectButton.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/094.png")));
            this.pollUrlSelectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NodeSelectDialog nsd = new NodeSelectDialog((Window)View.getSingleton().getMainFrame());
                    SiteNode node = null;
                    if (ContextAuthenticationPanel.this.getPollUrlField().getText().trim().length() > 0) {
                        try {
                            node = ContextAuthenticationPanel.this.getPollDataField().getText().trim().length() > 0 ? Model.getSingleton().getSession().getSiteTree().findNode(new URI(ContextAuthenticationPanel.this.getPollUrlField().getText(), false), "POST", ContextAuthenticationPanel.this.getPollDataField().getText()) : Model.getSingleton().getSession().getSiteTree().findNode(new URI(ContextAuthenticationPanel.this.getPollUrlField().getText(), false));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((node = nsd.showDialog(node)) != null && node.getHistoryReference() != null) {
                        try {
                            ContextAuthenticationPanel.this.getPollUrlField().setText(node.getHistoryReference().getURI().toString());
                            ContextAuthenticationPanel.this.getPollDataField().setText(node.getHistoryReference().getHttpMessage().getRequestBody().toString());
                        }
                        catch (Exception e1) {
                            LOGGER.error(e1.getMessage(), (Throwable)e1);
                        }
                    }
                }
            });
        }
        return this.pollUrlSelectButton;
    }

    private HsteTextField getPollUrlField() {
        if (this.pollUrlField == null) {
            this.pollUrlField = new HsteTextField();
        }
        return this.pollUrlField;
    }

    private HsteTextField getPollDataField() {
        if (this.pollDataField == null) {
            this.pollDataField = new HsteTextField();
        }
        return this.pollDataField;
    }

    private HsteTextArea getPollHeadersField() {
        if (this.pollHeadersField == null) {
            this.pollHeadersField = new HsteTextArea(2, 0);
        }
        return this.pollHeadersField;
    }

    private HsteTextField getLoggedInIndicatorRegexField() {
        if (this.loggedInIndicatorRegexField == null) {
            this.loggedInIndicatorRegexField = new HsteTextField();
        }
        return this.loggedInIndicatorRegexField;
    }

    private HsteTextField getLoggedOutIndicatorRegexField() {
        if (this.loggedOutIndicatorRegexField == null) {
            this.loggedOutIndicatorRegexField = new HsteTextField();
        }
        return this.loggedOutIndicatorRegexField;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.context-auth";
    }

    @Override
    public void initContextData(Session session, Context uiSharedContext) {
        this.selectedAuthenticationMethod = uiSharedContext.getAuthenticationMethod();
        LOGGER.debug("Initializing configuration panel for authentication method: {} for context {}", (Object)this.selectedAuthenticationMethod, (Object)uiSharedContext.getName());
        this.resetLoggedInOutIndicators();
        if (this.selectedAuthenticationMethod != null) {
            if (this.selectedAuthenticationMethod.getAuthCheckingStrategy() != null) {
                this.getAuthenticationVerifComboBox().getModel().setSelectedItem(new AuthCheckingStrategyType(this.selectedAuthenticationMethod.getAuthCheckingStrategy()));
            }
            this.setPollFieldStatuses((AuthCheckingStrategyType)this.getAuthenticationVerifComboBox().getSelectedItem());
            this.getPollUrlField().setText(this.selectedAuthenticationMethod.getPollUrl());
            this.getPollDataField().setText(this.selectedAuthenticationMethod.getPollData());
            this.getPollHeadersField().setText(this.selectedAuthenticationMethod.getPollHeaders());
            this.getPollFrequencySpinner().setValue(this.selectedAuthenticationMethod.getPollFrequency());
            this.getAuthFrequencyUnitsComboBox().setSelectedItem(new AuthPollFrequencyUnitsType(this.selectedAuthenticationMethod.getPollFrequencyUnits()));
            if (this.selectedAuthenticationMethod.getLoggedInIndicatorPattern() != null) {
                this.getLoggedInIndicatorRegexField().setText(this.selectedAuthenticationMethod.getLoggedInIndicatorPattern().pattern());
            } else {
                this.getLoggedInIndicatorRegexField().setText("");
            }
            if (this.selectedAuthenticationMethod.getLoggedOutIndicatorPattern() != null) {
                this.getLoggedOutIndicatorRegexField().setText(this.selectedAuthenticationMethod.getLoggedOutIndicatorPattern().pattern());
            } else {
                this.getLoggedOutIndicatorRegexField().setText("");
            }
            if (this.shownMethodType != null && this.shownMethodType.isTypeForMethod(this.selectedAuthenticationMethod)) {
                if (this.shownMethodType.hasOptionsPanel()) {
                    LOGGER.debug("Binding authentication method to existing panel of proper type for context {}", (Object)uiSharedContext.getName());
                    this.shownConfigPanel.bindMethod(this.selectedAuthenticationMethod, this.getAuthenticationIndicatorsPanel());
                }
                return;
            }
            for (AuthenticationMethodType type : this.extension.getAuthenticationMethodTypes()) {
                if (!type.isTypeForMethod(this.selectedAuthenticationMethod)) continue;
                LOGGER.debug("Binding authentication method to new panel of proper type for context {}", (Object)uiSharedContext.getName());
                this.needsConfirm = false;
                this.getAuthenticationMethodsComboBox().setSelectedItem(type);
                this.needsConfirm = true;
                break;
            }
        }
    }

    private void resetLoggedInOutIndicators() {
        this.getLoggedInIndicatorRegexField().setToolTipText(null);
        this.getLoggedInIndicatorRegexField().setEnabled(true);
        this.getLoggedOutIndicatorRegexField().setToolTipText(null);
        this.getLoggedOutIndicatorRegexField().setEnabled(true);
    }

    @Override
    public void validateContextData(Session session) throws Exception {
        if (this.shownConfigPanel != null) {
            this.shownConfigPanel.validateFields();
        }
        try {
            Pattern.compile(this.getLoggedInIndicatorRegexField().getText());
            Pattern.compile(this.getLoggedOutIndicatorRegexField().getText());
        }
        catch (PatternSyntaxException e) {
            throw new IllegalStateException(Constant.messages.getString("authentication.panel.error.illegalPattern", this.getUISharedContext().getName()), e);
        }
        if (((AuthCheckingStrategyType)this.getAuthenticationVerifComboBox().getSelectedItem()).getStrategy().equals((Object)AuthenticationMethod.AuthCheckingStrategy.POLL_URL)) {
            String url = this.getPollUrlField().getText();
            if (url.length() == 0) {
                throw new IllegalStateException(Constant.messages.getString("authentication.panel.error.nopollurl", this.getUISharedContext().getName()));
            }
            try {
                new URI(url, true);
            }
            catch (Exception e) {
                throw new IllegalStateException(Constant.messages.getString("authentication.panel.error.badpollurl", this.getUISharedContext().getName()), e);
            }
            for (String header : this.getPollHeadersField().getText().split("\n")) {
                String[] headerValue;
                if (header.trim().length() <= 0 || (headerValue = header.split(":")).length == 2) continue;
                throw new IllegalStateException(Constant.messages.getString("authentication.panel.error.badpollheaders", this.getUISharedContext().getName()));
            }
        }
    }

    private void saveMethod() {
        if (this.shownConfigPanel != null) {
            this.shownConfigPanel.saveMethod();
        }
        this.selectedAuthenticationMethod.setAuthCheckingStrategy(((AuthCheckingStrategyType)this.getAuthenticationVerifComboBox().getSelectedItem()).getStrategy());
        this.selectedAuthenticationMethod.setPollUrl(this.getPollUrlField().getText());
        this.selectedAuthenticationMethod.setPollData(this.getPollDataField().getText());
        this.selectedAuthenticationMethod.setPollHeaders(this.getPollHeadersField().getText());
        this.selectedAuthenticationMethod.setPollFrequency(this.getPollFrequencySpinner().getValue());
        this.selectedAuthenticationMethod.setPollFrequencyUnits(((AuthPollFrequencyUnitsType)this.getAuthFrequencyUnitsComboBox().getSelectedItem()).getUnits());
        this.selectedAuthenticationMethod.setLoggedInIndicatorPattern(this.getLoggedInIndicatorRegexField().getText());
        this.selectedAuthenticationMethod.setLoggedOutIndicatorPattern(this.getLoggedOutIndicatorRegexField().getText());
    }

    @Override
    public void saveContextData(Session session) throws Exception {
        this.saveMethod();
        Context context = session.getContext(this.getContextId());
        if (context.getAuthenticationMethod() != null && !this.shownMethodType.isTypeForMethod(context.getAuthenticationMethod())) {
            context.getAuthenticationMethod().onMethodDiscarded();
        }
        context.setAuthenticationMethod(this.selectedAuthenticationMethod);
        this.selectedAuthenticationMethod.onMethodPersisted();
    }

    @Override
    public void saveTemporaryContextData(Context uiSharedContext) {
        this.saveMethod();
        uiSharedContext.setAuthenticationMethod(this.selectedAuthenticationMethod);
    }

    private static class AuthCheckingStrategyType {
        private AuthenticationMethod.AuthCheckingStrategy strategy;

        public AuthCheckingStrategyType(AuthenticationMethod.AuthCheckingStrategy strategy) {
            this.strategy = strategy;
        }

        public AuthenticationMethod.AuthCheckingStrategy getStrategy() {
            return this.strategy;
        }

        public String toString() {
            return Constant.messages.getString(ContextAuthenticationPanel.STRATEGY_PREFIX + this.strategy.name().toLowerCase());
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthCheckingStrategyType)) {
                return false;
            }
            return this.strategy.equals((Object)((AuthCheckingStrategyType)o).getStrategy());
        }

        public int hashCode() {
            return this.strategy.hashCode();
        }

        public static List<AuthCheckingStrategyType> getAllValues() {
            ArrayList<AuthCheckingStrategyType> list = new ArrayList<AuthCheckingStrategyType>();
            for (AuthenticationMethod.AuthCheckingStrategy strategy : AuthenticationMethod.AuthCheckingStrategy.values()) {
                list.add(new AuthCheckingStrategyType(strategy));
            }
            return list;
        }
    }

    private static class AuthPollFrequencyUnitsType {
        private AuthenticationMethod.AuthPollFrequencyUnits units;

        public AuthPollFrequencyUnitsType(AuthenticationMethod.AuthPollFrequencyUnits units) {
            this.units = units;
        }

        public AuthenticationMethod.AuthPollFrequencyUnits getUnits() {
            return this.units;
        }

        public String toString() {
            return Constant.messages.getString(ContextAuthenticationPanel.FREQUENCY_UNITS_PREFIX + this.units.name().toLowerCase());
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthPollFrequencyUnitsType)) {
                return false;
            }
            return this.units.equals((Object)((AuthPollFrequencyUnitsType)o).getUnits());
        }

        public int hashCode() {
            return this.units.hashCode();
        }

        public static List<AuthPollFrequencyUnitsType> getAllValues() {
            ArrayList<AuthPollFrequencyUnitsType> list = new ArrayList<AuthPollFrequencyUnitsType>();
            for (AuthenticationMethod.AuthPollFrequencyUnits strategy : AuthenticationMethod.AuthPollFrequencyUnits.values()) {
                list.add(new AuthPollFrequencyUnitsType(strategy));
            }
            return list;
        }
    }

    private class AuthenticationIndicatorsPanelImpl
    implements AuthenticationIndicatorsPanel {
        private AuthenticationIndicatorsPanelImpl() {
        }

        @Override
        public String getLoggedInIndicatorPattern() {
            return ContextAuthenticationPanel.this.getLoggedInIndicatorRegexField().getText();
        }

        @Override
        public void setLoggedInIndicatorPattern(String loggedInIndicatorPattern) {
            ContextAuthenticationPanel.this.getLoggedInIndicatorRegexField().setText(loggedInIndicatorPattern);
        }

        @Override
        public void setLoggedInIndicatorEnabled(boolean enabled) {
            ContextAuthenticationPanel.this.getLoggedInIndicatorRegexField().setEnabled(enabled);
        }

        @Override
        public void setLoggedInIndicatorToolTip(String toolTip) {
            ContextAuthenticationPanel.this.getLoggedInIndicatorRegexField().setToolTipText(toolTip);
        }

        @Override
        public String getLoggedOutIndicatorPattern() {
            return ContextAuthenticationPanel.this.getLoggedOutIndicatorRegexField().getText();
        }

        @Override
        public void setLoggedOutIndicatorPattern(String loggedOutIndicatorPattern) {
            ContextAuthenticationPanel.this.getLoggedOutIndicatorRegexField().setText(loggedOutIndicatorPattern);
        }

        @Override
        public void setLoggedOutIndicatorEnabled(boolean enabled) {
            ContextAuthenticationPanel.this.getLoggedOutIndicatorRegexField().setEnabled(enabled);
        }

        @Override
        public void setLoggedOutIndicatorToolTip(String toolTip) {
            ContextAuthenticationPanel.this.getLoggedOutIndicatorRegexField().setToolTipText(toolTip);
        }
    }
}

