/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.authentication;

import com.stackhawk.hste.authentication.AuthenticationMethod;
import com.stackhawk.hste.authentication.AuthenticationMethodType;
import com.stackhawk.hste.authentication.FormBasedAuthenticationMethodType;
import com.stackhawk.hste.authentication.HttpAuthenticationMethodType;
import com.stackhawk.hste.authentication.JsonBasedAuthenticationMethodType;
import com.stackhawk.hste.authentication.ManualAuthenticationMethodType;
import com.stackhawk.hste.authentication.ScriptBasedAuthenticationMethodType;
import com.stackhawk.hste.extension.authentication.AuthenticationAPI;
import com.stackhawk.hste.extension.authentication.ContextAuthenticationPanel;
import com.stackhawk.hste.extension.authentication.HttpSenderAuthHeaderListener;
import com.stackhawk.hste.extension.authentication.PopupFlagLoggedInIndicatorMenu;
import com.stackhawk.hste.extension.authentication.PopupFlagLoggedOutIndicatorMenu;
import com.stackhawk.hste.extension.stdmenus.PopupContextMenuItemFactory;
import com.stackhawk.hste.model.Context;
import com.stackhawk.hste.model.ContextDataFactory;
import com.stackhawk.hste.view.AbstractContextPropertiesPanel;
import com.stackhawk.hste.view.ContextPanelFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Session;

public class ExtensionAuthentication
extends ExtensionAdaptor
implements ContextPanelFactory,
ContextDataFactory {
    public static final int EXTENSION_ORDER = 52;
    public static final String NAME = "ExtensionAuthentication";
    private static final int NO_AUTH_METHOD = -1;
    private static final Logger LOGGER = LogManager.getLogger(ExtensionAuthentication.class);
    List<AuthenticationMethodType> authenticationMethodTypes = new ArrayList<AuthenticationMethodType>();
    private Map<Integer, ContextAuthenticationPanel> contextPanelsMap = new HashMap<Integer, ContextAuthenticationPanel>();
    private PopupContextMenuItemFactory popupFlagLoggedInIndicatorMenuFactory;
    private PopupContextMenuItemFactory popupFlagLoggedOutIndicatorMenuFactory;
    private HttpSenderAuthHeaderListener httpSenderAuthHeaderListener;
    AuthenticationAPI api;

    public ExtensionAuthentication() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(52);
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("authentication.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addContextDataFactory(this);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupFlagLoggedInIndicatorMenu());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupFlagLoggedOutIndicatorMenu());
            extensionHook.getHookView().addContextPanelFactory(this);
        }
        this.loadAuthenticationMethodTypes(extensionHook);
        this.api = new AuthenticationAPI(this);
        extensionHook.addApiImplementor(this.api);
        extensionHook.addHttpSenderListener(this.getHttpSenderAuthHeaderListener());
    }

    @Override
    public AbstractContextPropertiesPanel getContextPanel(Context context) {
        ContextAuthenticationPanel panel = this.contextPanelsMap.get(context.getId());
        if (panel == null) {
            panel = new ContextAuthenticationPanel(this, context);
            this.contextPanelsMap.put(context.getId(), panel);
        }
        return panel;
    }

    @Override
    public String getAuthor() {
        return "HSTE Dev Team";
    }

    private PopupContextMenuItemFactory getPopupFlagLoggedInIndicatorMenu() {
        if (this.popupFlagLoggedInIndicatorMenuFactory == null) {
            this.popupFlagLoggedInIndicatorMenuFactory = new PopupContextMenuItemFactory("dd - " + Constant.messages.getString("context.flag.popup")){
                private static final long serialVersionUID = 2453839120088204122L;

                @Override
                public ExtensionPopupMenuItem getContextMenu(Context context, String parentMenu) {
                    return new PopupFlagLoggedInIndicatorMenu(context);
                }
            };
        }
        return this.popupFlagLoggedInIndicatorMenuFactory;
    }

    private PopupContextMenuItemFactory getPopupFlagLoggedOutIndicatorMenu() {
        if (this.popupFlagLoggedOutIndicatorMenuFactory == null) {
            this.popupFlagLoggedOutIndicatorMenuFactory = new PopupContextMenuItemFactory("dd - " + Constant.messages.getString("context.flag.popup")){
                private static final long serialVersionUID = 2453839120088204123L;

                @Override
                public ExtensionPopupMenuItem getContextMenu(Context context, String parentMenu) {
                    return new PopupFlagLoggedOutIndicatorMenu(context);
                }
            };
        }
        return this.popupFlagLoggedOutIndicatorMenuFactory;
    }

    private void loadAuthenticationMethodTypes(ExtensionHook hook) {
        this.authenticationMethodTypes = new ArrayList<AuthenticationMethodType>();
        this.authenticationMethodTypes.add(new FormBasedAuthenticationMethodType());
        this.authenticationMethodTypes.add(new HttpAuthenticationMethodType());
        this.authenticationMethodTypes.add(new ManualAuthenticationMethodType());
        this.authenticationMethodTypes.add(new ScriptBasedAuthenticationMethodType());
        this.authenticationMethodTypes.add(new JsonBasedAuthenticationMethodType());
        for (AuthenticationMethodType a : this.authenticationMethodTypes) {
            a.hook(hook);
        }
        LOGGER.info("Loaded authentication method types: {}", this.authenticationMethodTypes);
    }

    public void loadAuthenticationMethodType(ExtensionHook extensionHook, AuthenticationMethodType authenticationMethodType) {
        if (this.authenticationMethodTypes == null) {
            this.authenticationMethodTypes = new ArrayList<AuthenticationMethodType>();
        }
        this.authenticationMethodTypes.add(authenticationMethodType);
        this.authenticationMethodTypes.get(this.authenticationMethodTypes.size() - 1).hook(extensionHook);
        LOGGER.info("Loaded authentication management method types: {}", this.authenticationMethodTypes);
    }

    public List<AuthenticationMethodType> getAuthenticationMethodTypes() {
        return this.authenticationMethodTypes;
    }

    public AuthenticationMethodType getAuthenticationMethodTypeForIdentifier(int id) {
        for (AuthenticationMethodType t : this.getAuthenticationMethodTypes()) {
            if (t.getUniqueIdentifier() != id) continue;
            return t;
        }
        return null;
    }

    public URI getLoginRequestURIForContext(Context ctx) {
        if (!(ctx.getAuthenticationMethod() instanceof FormBasedAuthenticationMethodType.FormBasedAuthenticationMethod)) {
            return null;
        }
        FormBasedAuthenticationMethodType.FormBasedAuthenticationMethod method = (FormBasedAuthenticationMethodType.FormBasedAuthenticationMethod)ctx.getAuthenticationMethod();
        try {
            return new URI(method.getLoginRequestURL(), false);
        }
        catch (NullPointerException | URIException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void loadContextData(Session session, Context context) {
        block8: {
            try {
                AuthenticationMethodType t;
                List<String> typeL = session.getContextDataStrings(context.getId(), 200);
                if (typeL == null || typeL.size() <= 0 || (t = this.getAuthenticationMethodTypeForIdentifier(Integer.parseInt(typeL.get(0)))) == null) break block8;
                context.setAuthenticationMethod(t.loadMethodFromSession(session, context.getId()));
                String strategy = session.getContextDataString(context.getId(), 208, null);
                if (strategy != null) {
                    try {
                        context.getAuthenticationMethod().setAuthCheckingStrategy(AuthenticationMethod.AuthCheckingStrategy.valueOf(strategy));
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to parse auth checking strategy {}", (Object)strategy, (Object)e);
                    }
                }
                context.getAuthenticationMethod().setPollUrl(session.getContextDataString(context.getId(), 209, null));
                context.getAuthenticationMethod().setPollData(session.getContextDataString(context.getId(), 210, null));
                context.getAuthenticationMethod().setPollHeaders(session.getContextDataString(context.getId(), 213, null));
                context.getAuthenticationMethod().setPollFrequency(session.getContextDataInteger(context.getId(), 211, 0));
                String freqUnits = session.getContextDataString(context.getId(), 212, null);
                if (freqUnits != null) {
                    try {
                        context.getAuthenticationMethod().setPollFrequencyUnits(AuthenticationMethod.AuthPollFrequencyUnits.valueOf(freqUnits));
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to parse auth frequency units {}", (Object)freqUnits, (Object)e);
                    }
                }
                context.getAuthenticationMethod().setLoggedInIndicatorPattern(session.getContextDataString(context.getId(), 206, null));
                context.getAuthenticationMethod().setLoggedOutIndicatorPattern(session.getContextDataString(context.getId(), 207, null));
            }
            catch (DatabaseException e) {
                LOGGER.error("Unable to load Authentication method.", (Throwable)e);
            }
        }
    }

    @Override
    public void persistContextData(Session session, Context context) {
        try {
            int contextIdx = context.getId();
            AuthenticationMethodType t = context.getAuthenticationMethod().getType();
            session.setContextData(contextIdx, 200, Integer.toString(t.getUniqueIdentifier()));
            if (context.getAuthenticationMethod().getAuthCheckingStrategy() != null) {
                session.setContextData(contextIdx, 208, context.getAuthenticationMethod().getAuthCheckingStrategy().name());
            } else {
                session.clearContextDataForType(contextIdx, 208);
            }
            if (context.getAuthenticationMethod().getPollUrl() != null) {
                session.setContextData(contextIdx, 209, context.getAuthenticationMethod().getPollUrl());
            } else {
                session.clearContextDataForType(contextIdx, 209);
            }
            if (context.getAuthenticationMethod().getPollData() != null) {
                session.setContextData(contextIdx, 210, context.getAuthenticationMethod().getPollData());
            } else {
                session.clearContextDataForType(contextIdx, 210);
            }
            if (context.getAuthenticationMethod().getPollHeaders() != null) {
                session.setContextData(contextIdx, 213, context.getAuthenticationMethod().getPollHeaders());
            } else {
                session.clearContextDataForType(contextIdx, 213);
            }
            session.setContextData(contextIdx, 211, Integer.toString(context.getAuthenticationMethod().getPollFrequency()));
            if (context.getAuthenticationMethod().getPollFrequencyUnits() != null) {
                session.setContextData(contextIdx, 212, context.getAuthenticationMethod().getPollFrequencyUnits().name());
            } else {
                session.clearContextDataForType(contextIdx, 208);
            }
            ExtensionAuthentication.persistLoggedIndicator(session, contextIdx, 206, context.getAuthenticationMethod().getLoggedInIndicatorPattern());
            ExtensionAuthentication.persistLoggedIndicator(session, contextIdx, 207, context.getAuthenticationMethod().getLoggedOutIndicatorPattern());
            t.persistMethodToSession(session, contextIdx, context.getAuthenticationMethod());
        }
        catch (DatabaseException e) {
            LOGGER.error("Unable to persist Authentication method.", (Throwable)e);
        }
    }

    private static void persistLoggedIndicator(Session session, int contextIdx, int recordType, Pattern pattern) throws DatabaseException {
        if (pattern != null) {
            session.setContextData(contextIdx, recordType, pattern.toString());
        } else {
            session.clearContextDataForType(contextIdx, recordType);
        }
    }

    @Override
    public void discardContexts() {
        this.contextPanelsMap.clear();
    }

    @Override
    public void discardContext(Context ctx) {
        this.contextPanelsMap.remove(ctx.getId());
    }

    @Override
    public void exportContextData(Context ctx, Configuration config) {
        config.setProperty("context.authentication.type", (Object)ctx.getAuthenticationMethod().getType().getUniqueIdentifier());
        if (ctx.getAuthenticationMethod().getAuthCheckingStrategy() != null) {
            config.setProperty("context.authentication.strategy", (Object)ctx.getAuthenticationMethod().getAuthCheckingStrategy().name());
        }
        config.setProperty("context.authentication.pollurl", (Object)ctx.getAuthenticationMethod().getPollUrl());
        config.setProperty("context.authentication.polldata", (Object)ctx.getAuthenticationMethod().getPollData());
        config.setProperty("context.authentication.pollheaders", (Object)ctx.getAuthenticationMethod().getPollHeaders());
        config.setProperty("context.authentication.pollfreq", (Object)ctx.getAuthenticationMethod().getPollFrequency());
        if (ctx.getAuthenticationMethod().getPollFrequencyUnits() != null) {
            config.setProperty("context.authentication.pollunits", (Object)ctx.getAuthenticationMethod().getPollFrequencyUnits().name());
        }
        if (ctx.getAuthenticationMethod().getLoggedInIndicatorPattern() != null) {
            config.setProperty("context.authentication.loggedin", (Object)ctx.getAuthenticationMethod().getLoggedInIndicatorPattern().toString());
        }
        if (ctx.getAuthenticationMethod().getLoggedOutIndicatorPattern() != null) {
            config.setProperty("context.authentication.loggedout", (Object)ctx.getAuthenticationMethod().getLoggedOutIndicatorPattern().toString());
        }
        ctx.getAuthenticationMethod().getType().exportData(config, ctx.getAuthenticationMethod());
    }

    @Override
    public void importContextData(Context ctx, Configuration config) throws ConfigurationException {
        int typeId = config.getInt("context.authentication.type", -1);
        if (typeId == -1) {
            return;
        }
        AuthenticationMethodType authMethodType = this.getAuthenticationMethodTypeForIdentifier(typeId);
        if (authMethodType == null) {
            LOGGER.warn("No authentication method type found for ID: {}", (Object)typeId);
            return;
        }
        ctx.setAuthenticationMethod(authMethodType.createAuthenticationMethod(ctx.getId()));
        AuthenticationMethod method = ctx.getAuthenticationMethod();
        AuthenticationMethod.AuthCheckingStrategy strategy = AuthenticationMethod.AuthCheckingStrategy.valueOf(config.getString("context.authentication.strategy", AuthenticationMethod.AuthCheckingStrategy.EACH_RESP.name()));
        method.setAuthCheckingStrategy(strategy);
        method.setPollUrl(config.getString("context.authentication.pollurl", ""));
        method.setPollData(config.getString("context.authentication.polldata", ""));
        method.setPollHeaders(config.getString("context.authentication.pollheaders", ""));
        method.setPollFrequency(config.getInt("context.authentication.pollfreq", 60));
        AuthenticationMethod.AuthPollFrequencyUnits units = AuthenticationMethod.AuthPollFrequencyUnits.valueOf(config.getString("context.authentication.pollunits", AuthenticationMethod.AuthPollFrequencyUnits.REQUESTS.name()));
        method.setPollFrequencyUnits(units);
        method.setLoggedInIndicatorPattern(config.getString("context.authentication.loggedin", ""));
        method.setLoggedOutIndicatorPattern(config.getString("context.authentication.loggedout", ""));
        method.getType().importData(config, method);
    }

    private HttpSenderAuthHeaderListener getHttpSenderAuthHeaderListener() {
        if (this.httpSenderAuthHeaderListener == null) {
            this.httpSenderAuthHeaderListener = new HttpSenderAuthHeaderListener(System::getenv);
        }
        return this.httpSenderAuthHeaderListener;
    }
}

