/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.authentication;

import com.stackhawk.hste.extension.authentication.ContextAuthenticationPanel;
import com.stackhawk.hste.extension.httppanel.HttpPanelResponse;
import com.stackhawk.hste.model.Context;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.View;

public class PopupFlagLoggedInIndicatorMenu
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 3236789106409466394L;
    private String selectedText = null;
    private int contextId;

    public PopupFlagLoggedInIndicatorMenu(Context ctx) {
        this.contextId = ctx.getId();
        this.setText(Constant.messages.getString("authentication.popup.indicator.loggedIn", ctx.getName()));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupFlagLoggedInIndicatorMenu.this.performAction();
            }
        });
    }

    public void performAction() {
        SessionDialog sessionDialog = View.getSingleton().getSessionDialog();
        sessionDialog.recreateUISharedContexts(Model.getSingleton().getSession());
        Context uiSharedContext = sessionDialog.getUISharedContext(this.contextId);
        uiSharedContext.getAuthenticationMethod().setLoggedInIndicatorPattern(Pattern.quote(this.getSelectedText()));
        View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), ContextAuthenticationPanel.buildName(this.contextId), false);
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("context.flag.popup");
    }

    @Override
    public int getParentMenuIndex() {
        return 1;
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        if (invoker instanceof JTextComponent) {
            boolean responsePanel;
            JTextComponent txtComponent = (JTextComponent)invoker;
            boolean bl = responsePanel = SwingUtilities.getAncestorOfClass(HttpPanelResponse.class, txtComponent) != null;
            if (!responsePanel) {
                this.selectedText = null;
                return false;
            }
            this.selectedText = txtComponent.getSelectedText();
            if (this.selectedText == null || this.selectedText.length() == 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return true;
        }
        this.selectedText = null;
        return false;
    }

    public String getSelectedText() {
        return this.selectedText;
    }
}

