/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.authorization;

import com.stackhawk.hste.extension.api.ApiResponse;
import com.stackhawk.hste.extension.api.ApiResponseSet;
import com.stackhawk.hste.extension.authorization.AuthorizationDetectionMethod;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;

public class BasicAuthorizationDetectionMethod
implements AuthorizationDetectionMethod {
    public static final int METHOD_UNIQUE_ID = 0;
    public static final int NO_STATUS_CODE = -1;
    public static final String CONTEXT_CONFIG_AUTH_BASIC = "context.authorization.basic";
    public static final String CONTEXT_CONFIG_AUTH_BASIC_HEADER = "context.authorization.basic.header";
    public static final String CONTEXT_CONFIG_AUTH_BASIC_BODY = "context.authorization.basic.body";
    public static final String CONTEXT_CONFIG_AUTH_BASIC_LOGIC = "context.authorization.basic.logic";
    public static final String CONTEXT_CONFIG_AUTH_BASIC_CODE = "context.authorization.basic.code";
    protected LogicalOperator logicalOperator;
    protected int statusCode;
    protected Pattern headerPattern;
    protected Pattern bodyPattern;

    public BasicAuthorizationDetectionMethod(Integer statusCode, String headerRegex, String bodyRegex, LogicalOperator logicalOperator) {
        this.headerPattern = BasicAuthorizationDetectionMethod.buildPattern(headerRegex);
        this.bodyPattern = BasicAuthorizationDetectionMethod.buildPattern(bodyRegex);
        this.logicalOperator = logicalOperator;
        this.statusCode = statusCode != null ? statusCode : -1;
    }

    public BasicAuthorizationDetectionMethod(Configuration config) throws ConfigurationException {
        this.headerPattern = BasicAuthorizationDetectionMethod.buildPattern(config.getString(CONTEXT_CONFIG_AUTH_BASIC_HEADER));
        this.bodyPattern = BasicAuthorizationDetectionMethod.buildPattern(config.getString(CONTEXT_CONFIG_AUTH_BASIC_BODY));
        this.logicalOperator = LogicalOperator.valueOf(config.getString(CONTEXT_CONFIG_AUTH_BASIC_LOGIC));
        this.statusCode = config.getInt(CONTEXT_CONFIG_AUTH_BASIC_CODE);
    }

    private BasicAuthorizationDetectionMethod(int statusCode, Pattern headerPattern, Pattern bodyPattern, LogicalOperator composition) {
        this.headerPattern = headerPattern;
        this.bodyPattern = bodyPattern;
        this.logicalOperator = composition;
        this.statusCode = statusCode;
    }

    private static Pattern buildPattern(String regex) {
        if (regex == null || regex.isEmpty()) {
            return null;
        }
        return Pattern.compile(regex);
    }

    private static String getPatternString(Pattern pattern) {
        if (pattern == null) {
            return "";
        }
        return pattern.pattern();
    }

    @Override
    public boolean isResponseForUnauthorizedRequest(HttpMessage message) {
        boolean statusCodeMatch = message.getResponseHeader().getStatusCode() == this.statusCode;
        boolean headerMatch = this.headerPattern != null ? this.headerPattern.matcher(message.getResponseHeader().toString()).find() : false;
        boolean bodyMatch = this.bodyPattern != null ? this.bodyPattern.matcher(message.getResponseBody().toString()).find() : false;
        switch (this.logicalOperator) {
            case AND: {
                if (this.statusCode == -1 && this.headerPattern == null && this.bodyPattern == null) {
                    return false;
                }
                return !(!statusCodeMatch && this.statusCode != -1 || this.headerPattern != null && !headerMatch || this.bodyPattern != null && !bodyMatch);
            }
            case OR: {
                return statusCodeMatch || headerMatch || bodyMatch;
            }
        }
        return false;
    }

    public String toString() {
        return "BasicAuthorizationDetectionMethod [" + String.valueOf((Object)this.logicalOperator) + ": code=" + this.statusCode + ", header=" + String.valueOf(this.headerPattern) + ", body=" + String.valueOf(this.bodyPattern) + "]";
    }

    @Override
    public AuthorizationDetectionMethod clone() {
        return new BasicAuthorizationDetectionMethod(this.statusCode, this.headerPattern, this.bodyPattern, this.logicalOperator);
    }

    @Override
    public int getMethodUniqueIdentifier() {
        return 0;
    }

    @Override
    public void persistMethodToSession(Session session, int contextId) throws DatabaseException {
        session.setContextData(contextId, 231, Integer.toString(this.statusCode));
        if (this.headerPattern != null) {
            session.setContextData(contextId, 232, this.headerPattern.pattern());
        } else {
            session.clearContextDataForType(contextId, 232);
        }
        if (this.bodyPattern != null) {
            session.setContextData(contextId, 233, this.bodyPattern.pattern());
        } else {
            session.clearContextDataForType(contextId, 233);
        }
        session.setContextData(contextId, 234, this.logicalOperator.name());
    }

    public static BasicAuthorizationDetectionMethod loadMethodFromSession(Session session, int contextId) throws DatabaseException {
        int statusCode = -1;
        try {
            List<String> statusCodeL = session.getContextDataStrings(contextId, 231);
            statusCode = Integer.parseInt(statusCodeL.get(0));
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException statusCodeL) {
            // empty catch block
        }
        String headerRegex = null;
        try {
            List<String> loadedData = session.getContextDataStrings(contextId, 232);
            headerRegex = loadedData.get(0);
        }
        catch (IndexOutOfBoundsException | NullPointerException loadedData) {
            // empty catch block
        }
        String bodyRegex = null;
        try {
            List<String> loadedData = session.getContextDataStrings(contextId, 233);
            bodyRegex = loadedData.get(0);
        }
        catch (IndexOutOfBoundsException | NullPointerException loadedData) {
            // empty catch block
        }
        LogicalOperator operator = LogicalOperator.OR;
        try {
            List<String> loadedData = session.getContextDataStrings(contextId, 234);
            operator = LogicalOperator.valueOf(loadedData.get(0));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        return new BasicAuthorizationDetectionMethod((Integer)statusCode, headerRegex, bodyRegex, operator);
    }

    @Override
    public void exportMethodData(Configuration config) {
        config.setProperty(CONTEXT_CONFIG_AUTH_BASIC_HEADER, (Object)BasicAuthorizationDetectionMethod.getPatternString(this.headerPattern));
        config.setProperty(CONTEXT_CONFIG_AUTH_BASIC_BODY, (Object)BasicAuthorizationDetectionMethod.getPatternString(this.bodyPattern));
        config.setProperty(CONTEXT_CONFIG_AUTH_BASIC_LOGIC, (Object)this.logicalOperator.name());
        config.setProperty(CONTEXT_CONFIG_AUTH_BASIC_CODE, (Object)this.statusCode);
    }

    @Override
    public ApiResponse getApiResponseRepresentation() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("headerRegex", this.headerPattern == null ? "" : this.headerPattern.pattern());
        values.put("bodyRegex", this.bodyPattern == null ? "" : this.bodyPattern.pattern());
        values.put("statusCode", Integer.toString(this.statusCode));
        values.put("logicalOperator", this.logicalOperator.name());
        values.put("methodType", "basic");
        return new ApiResponseSet("authorizationDetectionMethod", values);
    }

    public static enum LogicalOperator {
        AND,
        OR;

    }
}

