/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.autoupdate;

import com.stackhawk.hste.control.AddOn;
import com.stackhawk.hste.extension.api.ApiAction;
import com.stackhawk.hste.extension.api.ApiException;
import com.stackhawk.hste.extension.api.ApiImplementor;
import com.stackhawk.hste.extension.api.ApiResponse;
import com.stackhawk.hste.extension.api.ApiResponseElement;
import com.stackhawk.hste.extension.api.ApiResponseList;
import com.stackhawk.hste.extension.api.ApiResponseSet;
import com.stackhawk.hste.extension.api.ApiView;
import com.stackhawk.hste.extension.autoupdate.ExtensionAutoUpdate;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;

public class AutoUpdateAPI
extends ApiImplementor {
    private static final Logger LOGGER = LogManager.getLogger(AutoUpdateAPI.class);
    private static final String PREFIX = "autoupdate";
    private static final String ACTION_DOWNLOAD_LATEST_RELEASE = "downloadLatestRelease";
    private static final String ACTION_INSTALL_ADDON = "installAddon";
    private static final String ACTION_INSTALL_LOCAL_ADDON = "installLocalAddon";
    private static final String ACTION_UNINSTALL_ADDON = "uninstallAddon";
    private static final String VIEW_LATEST_VERSION_NUMBER = "latestVersionNumber";
    private static final String VIEW_IS_LATEST_VERSION = "isLatestVersion";
    private static final String VIEW_INSTALLED_ADDONS = "installedAddons";
    private static final String VIEW_LOCAL_ADDONS = "localAddons";
    private static final String VIEW_NEW_ADDONS = "newAddons";
    private static final String VIEW_UPDATED_ADDONS = "updatedAddons";
    private static final String VIEW_MARKETPLACE_ADDONS = "marketplaceAddons";
    private static final String PARAM_ID = "id";
    private static final String PARAM_FILE = "file";
    private ExtensionAutoUpdate extension;

    public AutoUpdateAPI(ExtensionAutoUpdate extension) {
        this.extension = extension;
        this.addApiAction(new ApiAction(ACTION_DOWNLOAD_LATEST_RELEASE));
        this.addApiAction(new ApiAction(ACTION_INSTALL_ADDON, new String[]{PARAM_ID}));
        if (Constant.isDevMode()) {
            this.addApiAction(new ApiAction(ACTION_INSTALL_LOCAL_ADDON, new String[]{PARAM_FILE}));
        }
        this.addApiAction(new ApiAction(ACTION_UNINSTALL_ADDON, new String[]{PARAM_ID}));
        this.addApiView(new ApiView(VIEW_LATEST_VERSION_NUMBER));
        this.addApiView(new ApiView(VIEW_IS_LATEST_VERSION));
        this.addApiView(new ApiView(VIEW_INSTALLED_ADDONS));
        this.addApiView(new ApiView(VIEW_LOCAL_ADDONS));
        this.addApiView(new ApiView(VIEW_NEW_ADDONS));
        this.addApiView(new ApiView(VIEW_UPDATED_ADDONS));
        this.addApiView(new ApiView(VIEW_MARKETPLACE_ADDONS));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        LOGGER.debug("handleApiAction {} {}", (Object)name, (Object)params);
        if (ACTION_DOWNLOAD_LATEST_RELEASE.equals(name)) {
            if (this.downloadLatestRelease()) {
                return ApiResponseElement.OK;
            }
            return ApiResponseElement.FAIL;
        }
        if (ACTION_INSTALL_ADDON.equals(name)) {
            String id = params.getString(PARAM_ID);
            AddOn ao = this.extension.getAddOn(id);
            if (ao == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            ArrayList<String> l = new ArrayList<String>();
            l.add(id);
            String errorMessages = this.extension.installAddOns(l);
            if (errorMessages.length() == 0) {
                return ApiResponseElement.OK;
            }
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, errorMessages);
        }
        if (ACTION_INSTALL_LOCAL_ADDON.equals(name) && Constant.isDevMode()) {
            return this.extension.installLocalAddOnQuietly(AutoUpdateAPI.createPath(params.getString(PARAM_FILE))) ? ApiResponseElement.OK : ApiResponseElement.FAIL;
        }
        if (ACTION_UNINSTALL_ADDON.equals(name)) {
            String id = params.getString(PARAM_ID);
            AddOn ao = this.extension.getLocalVersionInfo().getAddOn(id);
            if (ao == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            if (ao.isMandatory()) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "The add-on can't be uninstalled, it is mandatory.");
            }
            ArrayList<String> l = new ArrayList<String>();
            l.add(id);
            String errorMessages = this.extension.uninstallAddOns(l);
            if (errorMessages.length() == 0) {
                return ApiResponseElement.OK;
            }
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, errorMessages);
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    private static Path createPath(String path) throws ApiException {
        try {
            return Paths.get(path, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_FILE, e);
        }
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        ApiResponse result;
        if (VIEW_LATEST_VERSION_NUMBER.equals(name)) {
            result = new ApiResponseElement(name, this.getLatestVersionNumber());
        } else if (VIEW_IS_LATEST_VERSION.equals(name)) {
            result = new ApiResponseElement(name, Boolean.toString(this.isLatestVersion()));
        } else if (VIEW_INSTALLED_ADDONS.equals(name)) {
            result = AutoUpdateAPI.createResponseList(name, this.extension.getInstalledAddOns(), true);
        } else if (VIEW_LOCAL_ADDONS.equals(name)) {
            result = AutoUpdateAPI.createResponseList(name, this.extension.getLocalAddOns(), true);
        } else if (VIEW_NEW_ADDONS.equals(name)) {
            result = AutoUpdateAPI.createResponseList(name, this.extension.getNewAddOns());
        } else if (VIEW_UPDATED_ADDONS.equals(name)) {
            result = AutoUpdateAPI.createResponseList(name, this.extension.getUpdatedAddOns());
        } else if (VIEW_MARKETPLACE_ADDONS.equals(name)) {
            result = AutoUpdateAPI.createResponseList(name, this.extension.getMarketplaceAddOns());
        } else {
            throw new ApiException(ApiException.Type.BAD_VIEW);
        }
        return result;
    }

    private static ApiResponseList createResponseList(String name, List<AddOn> addOns) {
        return AutoUpdateAPI.createResponseList(name, addOns, false);
    }

    private static ApiResponseList createResponseList(String name, List<AddOn> addOns, boolean localAddOns) {
        ApiResponseList response = new ApiResponseList(name);
        for (AddOn ao : addOns) {
            response.addItem(AutoUpdateAPI.addonToSet(ao, localAddOns));
        }
        return response;
    }

    private static ApiResponseSet<String> addonToSet(AddOn ao, boolean localAddOn) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PARAM_ID, ao.getId());
        map.put("name", ao.getName());
        map.put("author", ao.getAuthor());
        map.put("changes", ao.getChanges());
        map.put("description", ao.getDescription());
        map.put("hash", Objects.toString(ao.getHash(), ""));
        map.put("infoUrl", Objects.toString(ao.getInfo(), ""));
        map.put("repoUrl", Objects.toString(ao.getRepo(), ""));
        map.put("sizeInBytes", String.valueOf(ao.getSize()));
        map.put("status", ao.getStatus().toString());
        map.put("url", Objects.toString(ao.getUrl(), ""));
        map.put("version", Objects.toString(ao.getVersion(), ""));
        map.put("installationStatus", Objects.toString((Object)ao.getInstallationStatus(), ""));
        if (localAddOn) {
            map.put(PARAM_FILE, ao.getFile().toString());
            map.put("mandatory", String.valueOf(ao.isMandatory()));
        }
        return new ApiResponseSet<String>("addon", map);
    }

    public String getLatestVersionNumber() {
        return this.extension.getLatestVersionNumber();
    }

    public boolean isLatestVersion() {
        return this.extension.isLatestVersion();
    }

    public boolean downloadLatestRelease() {
        return this.extension.downloadLatestRelease();
    }
}

