/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.autoupdate;

import com.stackhawk.hste.network.HttpRequestConfig;
import com.stackhawk.hste.utils.HashUtils;
import java.io.File;
import java.net.Proxy;
import java.net.URL;
import java.util.Date;
import org.apache.commons.httpclient.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;

public class Downloader
extends Thread {
    private static final HttpRequestConfig HTTP_REQUEST_CONFIG = HttpRequestConfig.builder().setFollowRedirects(true).setNotifyListeners(false).build();
    private URL url;
    private File targetFile;
    private Exception exception = null;
    private long size = 0L;
    private boolean complete = false;
    private Date started = null;
    private Date finished = null;
    private boolean cancelDownload = false;
    private String hash = null;
    private boolean validated = false;
    private final int initiator;
    private static final Logger LOGGER = LogManager.getLogger(Downloader.class);

    @Deprecated
    public Downloader(URL url, Proxy proxy, File targetFile, String hash) {
        this(url, proxy, targetFile, 0L, hash);
    }

    @Deprecated
    public Downloader(URL url, Proxy proxy, File targetFile, long size, String hash) {
        this(url, targetFile, 0L, hash, 7);
    }

    Downloader(URL url, File targetFile, long size, String hash, int initiator) {
        this.url = url;
        this.targetFile = targetFile;
        this.size = size;
        this.hash = hash;
        this.initiator = initiator;
    }

    @Override
    public void run() {
        this.started = new Date();
        if (this.hash != null) {
            if (this.hash.indexOf(":") > 0) {
                this.downloadFile();
                if (!this.cancelDownload) {
                    this.validateHashDownload();
                }
            } else {
                LOGGER.debug("Not downloading file, hash field does not have valid content (\"<ALGORITHM>:<HASH>\"): {}", (Object)this.hash);
            }
        } else {
            LOGGER.debug("Not downloading file, does not have a hash: {}", (Object)this.url);
        }
        this.complete = true;
        this.finished = new Date();
        if (this.cancelDownload) {
            this.targetFile.delete();
        }
    }

    private void downloadFile() {
        try {
            HttpSender sender = new HttpSender(this.initiator);
            HttpMessage message = new HttpMessage(new URI(this.url.toString(), true));
            sender.sendAndReceive(message, HTTP_REQUEST_CONFIG, this.targetFile.toPath());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void validateHashDownload() {
        try {
            String algorithm = this.hash.substring(0, this.hash.indexOf(":"));
            String hashValue = this.hash.substring(this.hash.indexOf(":") + 1);
            String realHash = HashUtils.getHash(this.targetFile, algorithm);
            if (realHash.equalsIgnoreCase(hashValue)) {
                this.validated = true;
            } else {
                LOGGER.debug("Wrong hash - expected {} got {}", (Object)hashValue, (Object)realHash);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error checking hash", (Throwable)e);
        }
    }

    boolean isCancelled() {
        return this.cancelDownload;
    }

    public void cancelDownload() {
        this.cancelDownload = true;
        this.interrupt();
        if (this.complete && this.targetFile.exists()) {
            this.targetFile.delete();
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public URL getUrl() {
        return this.url;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public int getProgressPercent() {
        if (this.complete) {
            return 100;
        }
        if (this.size == 0L) {
            return 0;
        }
        return (int)(this.targetFile.length() * 100L / this.size);
    }

    public Date getStarted() {
        return this.started;
    }

    public Date getFinished() {
        return this.finished;
    }

    public String getHash() {
        return this.hash;
    }

    public boolean isValidated() {
        return this.validated;
    }
}

