/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.brk;

import com.stackhawk.hste.HSTE;
import com.stackhawk.hste.eventBus.Event;
import com.stackhawk.hste.eventBus.EventPublisher;
import com.stackhawk.hste.extension.httppanel.Message;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BreakEventPublisher
implements EventPublisher {
    private static BreakEventPublisher publisher = null;
    public static final String BREAK_POINT_HIT = "break.hit";
    public static final String BREAK_POINT_ACTIVE = "break.active";
    public static final String BREAK_POINT_INACTIVE = "break.inactive";
    public static final String MESSAGE_TYPE = "messageType";

    @Override
    public String getPublisherName() {
        return BreakEventPublisher.class.getCanonicalName();
    }

    public static synchronized BreakEventPublisher getPublisher() {
        if (publisher == null) {
            publisher = new BreakEventPublisher();
            HSTE.getEventBus().registerPublisher(publisher, BREAK_POINT_HIT, BREAK_POINT_ACTIVE, BREAK_POINT_INACTIVE);
        }
        return publisher;
    }

    public void publishHitEvent(Message msg) {
        this.publishEvent(BREAK_POINT_HIT, msg, msg.toEventData());
    }

    public void publishActiveEvent(Message msg) {
        this.publishEvent(BREAK_POINT_ACTIVE, msg, msg.toEventData());
    }

    public void publishInactiveEvent(Message msg) {
        this.publishEvent(BREAK_POINT_INACTIVE, msg, Collections.emptyMap());
    }

    private void publishEvent(String event, Message msg, Map<String, String> parameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(parameters);
        map.put(MESSAGE_TYPE, msg.getType());
        HSTE.getEventBus().publishSyncEvent(BreakEventPublisher.getPublisher(), new Event(BreakEventPublisher.getPublisher(), event, null, map));
    }
}

