/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.brk;

import com.stackhawk.hste.extension.brk.BreakEventPublisher;
import com.stackhawk.hste.extension.brk.BreakpointManagementInterface;
import com.stackhawk.hste.extension.brk.BreakpointMessageInterface;
import com.stackhawk.hste.extension.httppanel.Message;
import com.stackhawk.hste.utils.Stats;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BreakpointMessageHandler2 {
    private static final Logger LOGGER = LogManager.getLogger(BreakpointMessageHandler2.class);
    protected static final Object SEMAPHORE = new Object();
    protected final BreakpointManagementInterface breakMgmt;
    protected List<BreakpointMessageInterface> enabledBreakpoints;
    protected List<BreakpointMessageInterface> enabledIgnoreRules;
    private List<String> enabledKeyBreakpoints = new ArrayList<String>();

    public List<String> getEnabledKeyBreakpoints() {
        return this.enabledKeyBreakpoints;
    }

    public void setEnabledKeyBreakpoints(List<String> enabledKeyBreakpoints) {
        this.enabledKeyBreakpoints = enabledKeyBreakpoints;
    }

    public BreakpointMessageHandler2(BreakpointManagementInterface aBreakPanel) {
        this.breakMgmt = aBreakPanel;
    }

    public void setEnabledBreakpoints(List<BreakpointMessageInterface> breakpoints) {
        this.enabledBreakpoints = breakpoints;
    }

    public void setEnabledIgnoreRules(List<BreakpointMessageInterface> IgnoreRules) {
        this.enabledIgnoreRules = IgnoreRules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessageReceivedFromClient(Message aMessage, boolean onlyIfInScope) {
        if (!this.isBreakpoint(aMessage, true, onlyIfInScope)) {
            return true;
        }
        this.breakMgmt.breakpointHit();
        Stats.incCounter("stats.break.hit");
        BreakEventPublisher.getPublisher().publishHitEvent(aMessage);
        Object object = SEMAPHORE;
        synchronized (object) {
            if (this.breakMgmt.isHoldMessage(aMessage)) {
                BreakEventPublisher.getPublisher().publishActiveEvent(aMessage);
                this.setBreakDisplay(aMessage, true);
                this.waitUntilContinue(aMessage, true);
                BreakEventPublisher.getPublisher().publishInactiveEvent(aMessage);
            }
        }
        this.breakMgmt.clearAndDisableRequest();
        return !this.breakMgmt.isToBeDropped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessageReceivedFromServer(Message aMessage, boolean onlyIfInScope) {
        if (!this.isBreakpoint(aMessage, false, onlyIfInScope)) {
            return true;
        }
        this.breakMgmt.breakpointHit();
        Stats.incCounter("stats.break.hit");
        BreakEventPublisher.getPublisher().publishHitEvent(aMessage);
        Object object = SEMAPHORE;
        synchronized (object) {
            if (this.breakMgmt.isHoldMessage(aMessage)) {
                BreakEventPublisher.getPublisher().publishActiveEvent(aMessage);
                this.setBreakDisplay(aMessage, false);
                this.waitUntilContinue(aMessage, false);
                BreakEventPublisher.getPublisher().publishInactiveEvent(aMessage);
            }
        }
        this.breakMgmt.clearAndDisableResponse();
        return !this.breakMgmt.isToBeDropped();
    }

    private void setBreakDisplay(Message msg, boolean isRequest) {
        this.breakMgmt.setMessage(msg, isRequest);
        this.breakMgmt.breakpointDisplayed();
    }

    private void waitUntilContinue(Message aMessage, boolean isRequest) {
        while (this.breakMgmt.isHoldMessage(aMessage)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        this.breakMgmt.saveMessage(isRequest);
    }

    public boolean isBreakpoint(Message aMessage, boolean isRequest, boolean onlyIfInScope) {
        if (aMessage.isForceIntercept()) {
            return true;
        }
        if (this.isSkipOnIgnoreRules(aMessage, isRequest, onlyIfInScope)) {
            return false;
        }
        if (onlyIfInScope && !aMessage.isInScope()) {
            return false;
        }
        if (this.isBreakOnAllRequests(aMessage, isRequest)) {
            return true;
        }
        if (this.isBreakOnAllResponses(aMessage, isRequest)) {
            return true;
        }
        if (this.isBreakOnStepping(aMessage, isRequest)) {
            return true;
        }
        return this.isBreakOnEnabledBreakpoint(aMessage, isRequest, onlyIfInScope);
    }

    protected boolean isBreakOnAllRequests(Message aMessage, boolean isRequest) {
        return isRequest && this.breakMgmt.isBreakRequest();
    }

    protected boolean isBreakOnAllResponses(Message aMessage, boolean isRequest) {
        return !isRequest && this.breakMgmt.isBreakResponse();
    }

    protected boolean isBreakOnStepping(Message aMessage, boolean isRequest) {
        return this.breakMgmt.isStepping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBreakOnEnabledBreakpoint(Message aMessage, boolean isRequest, boolean onlyIfInScope) {
        if (this.enabledBreakpoints.isEmpty()) {
            return false;
        }
        List<BreakpointMessageInterface> list = this.enabledBreakpoints;
        synchronized (list) {
            for (BreakpointMessageInterface breakpoint : this.enabledBreakpoints) {
                if (!breakpoint.match(aMessage, isRequest, onlyIfInScope)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSkipOnIgnoreRules(Message aMessage, boolean isRequest, boolean onlyIfInScope) {
        if (this.enabledIgnoreRules == null || this.enabledIgnoreRules.isEmpty()) {
            return false;
        }
        List<BreakpointMessageInterface> list = this.enabledIgnoreRules;
        synchronized (list) {
            for (BreakpointMessageInterface ignoreRule : this.enabledIgnoreRules) {
                if (!ignoreRule.isEnabled() || !ignoreRule.match(aMessage, isRequest, onlyIfInScope)) continue;
                return true;
            }
        }
        return false;
    }
}

