/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.brk;

import com.stackhawk.hste.extension.brk.BreakpointMessageInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.Constant;

public class BreakpointsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -8160051343126299124L;
    private static final int COLUMN_COUNT = 3;
    private static final String[] columnNames = new String[]{Constant.messages.getString("brk.table.header.enabled"), Constant.messages.getString("brk.table.header.type"), Constant.messages.getString("brk.table.header.condition")};
    private List<BreakpointMessageInterface> breakpoints = new ArrayList<BreakpointMessageInterface>(0);
    private List<BreakpointMessageInterface> breakpointsEnabled = new ArrayList<BreakpointMessageInterface>(0);
    private Map<BreakpointMessageInterface, Integer> mapBreakpointRow = new HashMap<BreakpointMessageInterface, Integer>();
    private int lastAffectedRow = -1;

    public List<BreakpointMessageInterface> getBreakpointsList() {
        return this.breakpoints;
    }

    public List<BreakpointMessageInterface> getBreakpointsEnabledList() {
        return this.breakpointsEnabled;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.breakpoints.size();
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object obj = null;
        BreakpointMessageInterface breakpoint = this.breakpoints.get(row);
        obj = column == 0 ? Boolean.valueOf(breakpoint.isEnabled()) : (column == 1 ? breakpoint.getType() : breakpoint.getDisplayMessage());
        return obj;
    }

    public BreakpointMessageInterface getBreakpointAtRow(int row) {
        return this.breakpoints.get(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBreakpoint(BreakpointMessageInterface breakpoint) {
        this.breakpoints.add(breakpoint);
        this.fireTableRowsInserted(this.breakpoints.size() - 1, this.breakpoints.size() - 1);
        this.rebuildMapBreakpointRow();
        this.lastAffectedRow = this.mapBreakpointRow.get(breakpoint);
        if (breakpoint.isEnabled()) {
            List<BreakpointMessageInterface> list = this.breakpointsEnabled;
            synchronized (list) {
                this.breakpointsEnabled.add(breakpoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editBreakpoint(BreakpointMessageInterface oldBreakpoint, BreakpointMessageInterface newBreakpoint) {
        int row = this.mapBreakpointRow.remove(oldBreakpoint);
        this.breakpoints.remove(row);
        this.fireTableRowsDeleted(row, row);
        this.mapBreakpointRow.put(newBreakpoint, 0);
        this.breakpoints.add(newBreakpoint);
        this.fireTableRowsInserted(this.breakpoints.size() - 1, this.breakpoints.size() - 1);
        this.rebuildMapBreakpointRow();
        this.lastAffectedRow = this.mapBreakpointRow.get(newBreakpoint);
        List<BreakpointMessageInterface> list = this.breakpointsEnabled;
        synchronized (list) {
            if (oldBreakpoint.isEnabled()) {
                this.breakpointsEnabled.remove(oldBreakpoint);
            }
            if (newBreakpoint.isEnabled()) {
                this.breakpointsEnabled.add(newBreakpoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBreakpoint(BreakpointMessageInterface breakpoint) {
        Integer row = this.mapBreakpointRow.remove(breakpoint);
        if (row != null) {
            this.breakpoints.remove(breakpoint);
            this.fireTableRowsDeleted(row, row);
            this.rebuildMapBreakpointRow();
            List<BreakpointMessageInterface> list = this.breakpointsEnabled;
            synchronized (list) {
                if (breakpoint.isEnabled()) {
                    this.breakpointsEnabled.remove(breakpoint);
                }
            }
        }
    }

    public int getLastAffectedRow() {
        return this.lastAffectedRow;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object value, int row, int column) {
        if (column == 0 && value instanceof Boolean) {
            boolean isEnabled = this.breakpoints.get(row).isEnabled();
            this.breakpoints.get(row).setEnabled((Boolean)value);
            this.fireTableCellUpdated(row, column);
            if (isEnabled) {
                List<BreakpointMessageInterface> list = this.breakpointsEnabled;
                synchronized (list) {
                    this.breakpointsEnabled.remove(this.breakpoints.get(row));
                }
            }
            List<BreakpointMessageInterface> list = this.breakpointsEnabled;
            synchronized (list) {
                this.breakpointsEnabled.add(this.breakpoints.get(row));
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    private void rebuildMapBreakpointRow() {
        this.mapBreakpointRow.clear();
        int i = 0;
        Iterator<BreakpointMessageInterface> iterator = this.breakpoints.iterator();
        while (iterator.hasNext()) {
            this.mapBreakpointRow.put(iterator.next(), i);
            ++i;
        }
    }
}

