/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.brk.impl.http;

import com.stackhawk.hste.extension.brk.BreakpointMessageInterface;
import com.stackhawk.hste.extension.brk.BreakpointsUiManagerInterface;
import com.stackhawk.hste.extension.brk.ExtensionBreak;
import com.stackhawk.hste.extension.brk.impl.http.BreakAddEditDialog;
import com.stackhawk.hste.extension.brk.impl.http.HttpBreakpointMessage;
import com.stackhawk.hste.extension.brk.impl.http.PopupMenuAddBreakHistory;
import com.stackhawk.hste.extension.brk.impl.http.PopupMenuAddBreakSites;
import com.stackhawk.hste.extension.httppanel.Message;
import com.stackhawk.hste.model.StructuralSiteNode;
import java.awt.Dimension;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;

public class HttpBreakpointsUiManagerInterface
implements BreakpointsUiManagerInterface {
    private BreakAddEditDialog breakDialog = null;
    private ExtensionBreak extensionBreak;
    private PopupMenuAddBreakSites popupMenuAddBreakSites = null;
    private PopupMenuAddBreakHistory popupMenuAddBreakHistory = null;

    public HttpBreakpointsUiManagerInterface(ExtensionHookMenu hookMenu, ExtensionBreak extensionBreak) {
        this.extensionBreak = extensionBreak;
        hookMenu.addPopupMenuItem(this.getPopupMenuAddBreakSites());
        hookMenu.addPopupMenuItem(this.getPopupMenuAddBreakHistory());
    }

    public Class<HttpMessage> getMessageClass() {
        return HttpMessage.class;
    }

    public Class<HttpBreakpointMessage> getBreakpointClass() {
        return HttpBreakpointMessage.class;
    }

    @Override
    public String getType() {
        return "HTTP";
    }

    @Override
    public void handleAddBreakpoint(Message aMessage) {
        this.showAddDialog(aMessage);
    }

    public void handleAddBreakpoint(String url) {
        this.showAddDialog(url, HttpBreakpointMessage.Match.regex);
    }

    void addBreakpoint(HttpBreakpointMessage breakpoint) {
        this.extensionBreak.addBreakpoint(breakpoint);
    }

    @Override
    public void handleEditBreakpoint(BreakpointMessageInterface breakpoint) {
        this.showEditDialog((HttpBreakpointMessage)breakpoint);
    }

    void editBreakpoint(BreakpointMessageInterface oldBreakpoint, BreakpointMessageInterface newBreakpoint) {
        this.extensionBreak.editBreakpoint(oldBreakpoint, newBreakpoint);
    }

    @Override
    public void handleRemoveBreakpoint(BreakpointMessageInterface breakpoint) {
        this.extensionBreak.removeBreakpoint(breakpoint);
    }

    @Override
    public void reset() {
    }

    private void populateAddDialogAndSetVisible(String url, HttpBreakpointMessage.Match match) {
        this.breakDialog.init(new HttpBreakpointMessage(url, HttpBreakpointMessage.Location.url, match, false, true), true);
        this.breakDialog.setVisible(true);
    }

    private void showAddDialog(Message aMessage) {
        HttpBreakpointMessage.Match match = HttpBreakpointMessage.Match.regex;
        HttpMessage msg = (HttpMessage)aMessage;
        String regex = "";
        if (msg.getHistoryRef() != null && msg.getHistoryRef().getSiteNode() != null) {
            try {
                regex = new StructuralSiteNode(msg.getHistoryRef().getSiteNode()).getRegexPattern(false);
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        if (regex.length() == 0 && msg.getRequestHeader().getURI() != null) {
            regex = msg.getRequestHeader().getURI().toString();
            match = HttpBreakpointMessage.Match.contains;
        }
        this.showAddDialog(regex, match);
    }

    private void showAddDialog(String url, HttpBreakpointMessage.Match match) {
        if (this.breakDialog == null) {
            this.breakDialog = new BreakAddEditDialog(this, View.getSingleton().getMainFrame(), new Dimension(407, 255));
        }
        this.populateAddDialogAndSetVisible(url, match);
    }

    private void populateEditDialogAndSetVisible(HttpBreakpointMessage breakpoint) {
        this.breakDialog.init(breakpoint, false);
        this.breakDialog.setVisible(true);
    }

    private void showEditDialog(HttpBreakpointMessage breakpoint) {
        if (this.breakDialog == null) {
            this.breakDialog = new BreakAddEditDialog(this, View.getSingleton().getMainFrame(), new Dimension(407, 255));
        }
        this.populateEditDialogAndSetVisible(breakpoint);
    }

    private PopupMenuAddBreakSites getPopupMenuAddBreakSites() {
        if (this.popupMenuAddBreakSites == null) {
            this.popupMenuAddBreakSites = new PopupMenuAddBreakSites(this);
        }
        return this.popupMenuAddBreakSites;
    }

    private PopupMenuAddBreakHistory getPopupMenuAddBreakHistory() {
        if (this.popupMenuAddBreakHistory == null) {
            this.popupMenuAddBreakHistory = new PopupMenuAddBreakHistory(this.extensionBreak);
        }
        return this.popupMenuAddBreakHistory;
    }
}

