/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.brk.impl.http;

import com.stackhawk.hste.extension.brk.ExtensionBreak;
import com.stackhawk.hste.view.messagecontainer.http.HttpMessageContainer;
import com.stackhawk.hste.view.popup.PopupMenuItemHistoryReferenceContainer;
import com.stackhawk.hste.view.popup.PopupMenuItemHttpMessageContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class PopupMenuAddBreakHistory
extends PopupMenuItemHistoryReferenceContainer {
    private static final long serialVersionUID = -1984801437717248474L;
    private static final Logger LOGGER = LogManager.getLogger(PopupMenuAddBreakHistory.class);
    private final ExtensionBreak extension;

    public PopupMenuAddBreakHistory(ExtensionBreak extension) {
        super(Constant.messages.getString("brk.add.popup"));
        this.extension = extension;
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuItemHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        return invoker == PopupMenuItemHttpMessageContainer.Invoker.HISTORY_PANEL;
    }

    @Override
    public void performAction(HistoryReference href) {
        try {
            this.extension.addUiBreakpoint(href.getHttpMessage());
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.extension.getView().showWarningDialog(Constant.messages.getString("brk.add.error.history"));
        }
    }
}

