/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.callback;

import com.stackhawk.hste.extension.callback.CallbackParam;
import com.stackhawk.hste.extension.callback.ExtensionCallback;
import com.stackhawk.hste.utils.HstePortNumberSpinner;
import com.stackhawk.hste.utils.HsteTextField;
import com.stackhawk.hste.utils.NetworkUtils;
import com.stackhawk.hste.view.LayoutHelper;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;

@Deprecated
public class OptionsCallbackPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panel = null;
    private ExtensionCallback ext;
    private JComboBox<String> localAddress = null;
    private JComboBox<String> remoteAddress = null;
    private HsteTextField testURL = null;
    private JCheckBox randomPort = null;
    private HstePortNumberSpinner spinnerPort = null;
    private JCheckBox secure;

    public OptionsCallbackPanel(ExtensionCallback ext) {
        this.ext = ext;
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("callback.options.title"));
        this.add((Component)this.getCallbackPanel(), this.getCallbackPanel().getName());
    }

    private JPanel getCallbackPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            int currentRowIndex = -1;
            JLabel localAddrLabel = new JLabel(Constant.messages.getString("callback.options.label.localaddress"));
            localAddrLabel.setLabelFor(this.getLocalAddress());
            this.panel.add((Component)localAddrLabel, LayoutHelper.getGBC(0, ++currentRowIndex, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add(this.getLocalAddress(), LayoutHelper.getGBC(1, currentRowIndex, 1, 0.5, new Insets(2, 2, 2, 2)));
            JLabel remoteAddrLabel = new JLabel(Constant.messages.getString("callback.options.label.remoteaddress"));
            remoteAddrLabel.setLabelFor(this.getRemoteAddress());
            this.panel.add((Component)remoteAddrLabel, LayoutHelper.getGBC(0, ++currentRowIndex, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add(this.getRemoteAddress(), LayoutHelper.getGBC(1, currentRowIndex, 1, 0.5, new Insets(2, 2, 2, 2)));
            JLabel secureLabel = new JLabel(Constant.messages.getString("callback.options.label.secure"));
            secureLabel.setLabelFor(this.getSecure());
            this.panel.add((Component)secureLabel, LayoutHelper.getGBC(0, ++currentRowIndex, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add((Component)this.getSecure(), LayoutHelper.getGBC(1, currentRowIndex, 1, 0.5, new Insets(2, 2, 2, 2)));
            JLabel rndPortLabel = new JLabel(Constant.messages.getString("callback.options.label.rndport"));
            rndPortLabel.setLabelFor(this.getSpinnerPort());
            this.panel.add((Component)rndPortLabel, LayoutHelper.getGBC(0, ++currentRowIndex, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add((Component)this.getRandomPort(), LayoutHelper.getGBC(1, currentRowIndex, 1, 0.5, new Insets(2, 2, 2, 2)));
            JLabel portLabel = new JLabel(Constant.messages.getString("callback.options.label.port"));
            portLabel.setLabelFor(this.getSpinnerPort());
            this.panel.add((Component)portLabel, LayoutHelper.getGBC(0, ++currentRowIndex, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add((Component)this.getSpinnerPort(), LayoutHelper.getGBC(1, currentRowIndex, 1, 0.5, new Insets(2, 2, 2, 2)));
            JLabel testUrlLabel = new JLabel(Constant.messages.getString("callback.options.label.testurl"));
            testUrlLabel.setLabelFor(this.getTestURL());
            this.panel.add((Component)testUrlLabel, LayoutHelper.getGBC(0, ++currentRowIndex, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add((Component)this.getTestURL(), LayoutHelper.getGBC(1, currentRowIndex, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panel.add((Component)new JLabel(), LayoutHelper.getGBC(0, 20, 2, 0.5, 1.0));
        }
        return this.panel;
    }

    private JComboBox<String> getLocalAddress() {
        if (this.localAddress == null) {
            this.localAddress = new JComboBox();
        }
        return this.localAddress;
    }

    private JComboBox<String> getRemoteAddress() {
        if (this.remoteAddress == null) {
            this.remoteAddress = new JComboBox();
            this.remoteAddress.setEditable(true);
        }
        return this.remoteAddress;
    }

    private HsteTextField getTestURL() {
        if (this.testURL == null) {
            this.testURL = new HsteTextField();
            this.testURL.setEditable(false);
            this.testURL.setFocusable(true);
        }
        return this.testURL;
    }

    private JCheckBox getRandomPort() {
        if (this.randomPort == null) {
            this.randomPort = new JCheckBox();
            this.randomPort.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    OptionsCallbackPanel.this.getSpinnerPort().setEnabled(!OptionsCallbackPanel.this.randomPort.isSelected());
                }
            });
        }
        return this.randomPort;
    }

    private JCheckBox getSecure() {
        if (this.secure == null) {
            this.secure = new JCheckBox();
        }
        return this.secure;
    }

    private HstePortNumberSpinner getSpinnerPort() {
        if (this.spinnerPort == null) {
            this.spinnerPort = new HstePortNumberSpinner(0);
        }
        return this.spinnerPort;
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam optionsParam = (OptionsParam)obj;
        CallbackParam proxyParam = optionsParam.getParamSet(CallbackParam.class);
        List<String> allAddrs = NetworkUtils.getAvailableAddresses(false);
        this.localAddress.removeAllItems();
        this.localAddress.addItem("0.0.0.0");
        for (String addr : allAddrs) {
            this.localAddress.addItem(addr);
        }
        this.localAddress.setSelectedItem(proxyParam.getLocalAddress());
        this.remoteAddress.removeAllItems();
        for (String addr : allAddrs) {
            this.remoteAddress.addItem(addr);
        }
        this.remoteAddress.setSelectedItem(proxyParam.getRemoteAddress());
        this.secure.setSelected(proxyParam.isSecure());
        if (proxyParam.getPort() == 0) {
            this.getRandomPort().setSelected(true);
            this.getSpinnerPort().setEnabled(false);
            this.getSpinnerPort().setValue(this.ext.getPort());
        } else {
            this.getSpinnerPort().setEnabled(true);
            this.getSpinnerPort().setValue(proxyParam.getPort());
        }
        this.getTestURL().setText(this.ext.getTestUrl());
    }

    @Override
    public void validateParam(Object obj) throws Exception {
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam optionsParam = (OptionsParam)obj;
        CallbackParam proxyParam = optionsParam.getParamSet(CallbackParam.class);
        proxyParam.setLocalAddress((String)this.localAddress.getSelectedItem());
        proxyParam.setRemoteAddress((String)this.remoteAddress.getSelectedItem());
        proxyParam.setSecure(this.secure.isSelected());
        if (this.getRandomPort().isSelected()) {
            proxyParam.setPort(0);
        } else {
            proxyParam.setPort(this.spinnerPort.getValue());
        }
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.callback";
    }
}

