/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.custompages;

import com.stackhawk.hste.extension.custompages.DialogAddCustomPage;
import com.stackhawk.hste.extension.httppanel.HttpPanelResponse;
import com.stackhawk.hste.model.Context;
import java.awt.Component;
import java.awt.Window;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;

public class PopupFlagCustomPageIndicatorMenu
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 6071498013529265858L;
    private String selectedText = null;
    private int contextId;

    public PopupFlagCustomPageIndicatorMenu(Context ctx) {
        this.contextId = ctx.getId();
        this.setText(Constant.messages.getString("custompages.popup.indicator", ctx.getName()));
        this.addActionListener(event -> this.performAction());
    }

    private void performAction() {
        Context currentContext = Model.getSingleton().getSession().getContext(this.contextId);
        DialogAddCustomPage dialogAddCustomPage = this.getDialogAddCustomPage(currentContext, this.getSelectedText());
        dialogAddCustomPage.setVisible(true);
        currentContext.addCustomPage(dialogAddCustomPage.getCustomPage());
    }

    private DialogAddCustomPage getDialogAddCustomPage(Context currentContext, String selectedText) {
        DialogAddCustomPage dialogAddCustomPage = new DialogAddCustomPage((Window)View.getSingleton().getMainFrame());
        dialogAddCustomPage.setWorkingContext(currentContext);
        dialogAddCustomPage.getPageMatcherTextField().setText(Pattern.quote(selectedText));
        dialogAddCustomPage.getRegexCheckBox().setSelected(true);
        return dialogAddCustomPage;
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("context.flag.popup");
    }

    @Override
    public int getParentMenuIndex() {
        return 1;
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        if (invoker instanceof JTextComponent) {
            boolean responsePanel;
            JTextComponent txtComponent = (JTextComponent)invoker;
            boolean bl = responsePanel = SwingUtilities.getAncestorOfClass(HttpPanelResponse.class, txtComponent) != null;
            if (!responsePanel) {
                this.selectedText = null;
                return false;
            }
            this.selectedText = txtComponent.getSelectedText();
            this.setEnabled(this.selectedText != null && this.selectedText.length() != 0);
            return true;
        }
        this.selectedText = null;
        return false;
    }

    public String getSelectedText() {
        return this.selectedText;
    }
}

