/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.ext;

import com.stackhawk.hste.extension.ext.ExtensionExtension;
import com.stackhawk.hste.extension.ext.ExtensionParam;
import com.stackhawk.hste.extension.ext.OptionsExtensionTableModel;
import com.stackhawk.hste.utils.DesktopUtils;
import com.stackhawk.hste.utils.DisplayUtils;
import com.stackhawk.hste.utils.HsteHtmlLabel;
import com.stackhawk.hste.utils.HsteLabel;
import com.stackhawk.hste.view.HsteTable;
import com.stackhawk.hste.view.LayoutHelper;
import com.stackhawk.hste.view.panels.TableFilterPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;

public class OptionsExtensionPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private HsteTable tableExt = null;
    private JScrollPane jScrollPane = null;
    private JPanel detailsPane = null;
    private HsteLabel extName = new HsteLabel();
    private JLabel addOnNameLabel = new JLabel();
    private HsteLabel addOnName = new HsteLabel();
    private HsteLabel extAuthor = new HsteLabel();
    private HsteLabel extURL = new HsteLabel();
    private JTextArea extDescription = new JTextArea();
    private OptionsExtensionTableModel extensionModel = null;
    private JScrollPane extDescScrollPane = null;
    private JButton urlLaunchButton = null;
    private static final Logger LOGGER = LogManager.getLogger(OptionsExtensionPanel.class);

    public OptionsExtensionPanel(ExtensionExtension ext) {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.setSize(409, 268);
        this.setName(Constant.messages.getString("options.ext.title"));
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 0, 10, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        this.add((Component)new HsteHtmlLabel(Constant.messages.getString("options.ext.label.enable")), gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add(new TableFilterPanel<HsteTable>(this.getTableExtension()), gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 0.75;
        gbc.fill = 1;
        this.add((Component)this.getJScrollPane(), gbc);
        gbc.weighty = 0.25;
        this.add((Component)this.getDetailsPane(), gbc);
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam optionsParam = (OptionsParam)obj;
        ExtensionParam extParam = optionsParam.getExtensionParam();
        this.extensionModel.setExtensionsState(extParam.getExtensionsState());
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam optionsParam = (OptionsParam)obj;
        optionsParam.getExtensionParam().setExtensionsState(this.extensionModel.getExtensionsState());
    }

    private HsteTable getTableExtension() {
        if (this.tableExt == null) {
            this.tableExt = new HsteTable(){
                private static final long serialVersionUID = 1L;

                @Override
                protected HsteTable.AutoScrollAction createAutoScrollAction() {
                    return null;
                }
            };
            this.tableExt.setAutoScrollOnNewValues(false);
            this.tableExt.setModel(this.getExtensionModel());
            this.tableExt.setRowHeight(DisplayUtils.getScaledSize(18));
            this.tableExt.getColumnModel().getColumn(0).setPreferredWidth(DisplayUtils.getScaledSize(70));
            this.tableExt.getColumnModel().getColumn(1).setPreferredWidth(DisplayUtils.getScaledSize(70));
            this.tableExt.getColumnModel().getColumn(2).setPreferredWidth(DisplayUtils.getScaledSize(120));
            this.tableExt.getColumnModel().getColumn(3).setPreferredWidth(DisplayUtils.getScaledSize(220));
            this.tableExt.setSortOrder(3, SortOrder.ASCENDING);
            ListSelectionListener sl = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent arg0) {
                    Extension ext;
                    int selectedRow = OptionsExtensionPanel.this.tableExt.getSelectedRow();
                    if (selectedRow > -1 && (ext = OptionsExtensionPanel.this.getExtensionModel().getExtension(OptionsExtensionPanel.this.tableExt.convertRowIndexToModel(selectedRow))) != null) {
                        try {
                            OptionsExtensionPanel.this.extName.setText(ext.getUIName());
                            boolean addOnExtension = ext.getAddOn() != null;
                            OptionsExtensionPanel.this.addOnNameLabel.setVisible(addOnExtension);
                            OptionsExtensionPanel.this.addOnName.setVisible(addOnExtension);
                            OptionsExtensionPanel.this.addOnName.setText(addOnExtension ? ext.getAddOn().getName() : "");
                            OptionsExtensionPanel.this.extDescription.setText(ext.getDescription());
                            OptionsExtensionPanel.this.extAuthor.setText(ext.getAuthor());
                            if (ext.getURL() != null) {
                                OptionsExtensionPanel.this.extURL.setText(ext.getURL().toString());
                                OptionsExtensionPanel.this.getUrlLaunchButton().setEnabled(true);
                            } else {
                                OptionsExtensionPanel.this.extURL.setText("");
                                OptionsExtensionPanel.this.getUrlLaunchButton().setEnabled(false);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            };
            this.tableExt.getSelectionModel().addListSelectionListener(sl);
            this.tableExt.setColumnControlVisible(true);
        }
        return this.tableExt;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView((Component)((Object)this.getTableExtension()));
            this.jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        }
        return this.jScrollPane;
    }

    private JPanel getDetailsPane() {
        if (this.detailsPane == null) {
            this.detailsPane = new JPanel();
            this.detailsPane.setBorder(BorderFactory.createEtchedBorder(0));
            this.detailsPane.setLayout(new GridBagLayout());
            this.detailsPane.add((Component)new JLabel(Constant.messages.getString("options.ext.label.name")), LayoutHelper.getGBC(0, 1, 1, 0.25));
            this.detailsPane.add((Component)this.extName, LayoutHelper.getGBC(1, 1, 1, 0.75));
            this.addOnNameLabel = new JLabel(Constant.messages.getString("options.ext.label.addon"));
            this.detailsPane.add((Component)this.addOnNameLabel, LayoutHelper.getGBC(0, 2, 1, 0.25));
            this.detailsPane.add((Component)this.addOnName, LayoutHelper.getGBC(1, 2, 1, 0.75));
            this.addOnNameLabel.setVisible(false);
            this.addOnName.setVisible(false);
            this.detailsPane.add((Component)new JLabel(Constant.messages.getString("options.ext.label.author")), LayoutHelper.getGBC(0, 3, 1, 0.25));
            this.detailsPane.add((Component)this.extAuthor, LayoutHelper.getGBC(1, 3, 1, 0.75));
            this.detailsPane.add((Component)new JLabel(Constant.messages.getString("options.ext.label.url")), LayoutHelper.getGBC(0, 4, 1, 0.25));
            if (DesktopUtils.canOpenUrlInBrowser()) {
                this.detailsPane.add((Component)this.getUrlLaunchButton(), LayoutHelper.getGBC(1, 4, 1, 0.0, 0.0, 0));
            } else {
                this.detailsPane.add((Component)this.extURL, LayoutHelper.getGBC(1, 4, 1, 0.5));
            }
            this.detailsPane.add((Component)this.getExtDescJScrollPane(), LayoutHelper.getGBC(0, 5, 2, 1.0, 1.0));
        }
        return this.detailsPane;
    }

    private JButton getUrlLaunchButton() {
        if (this.urlLaunchButton == null) {
            this.urlLaunchButton = new JButton(Constant.messages.getString("options.ext.button.openurl"));
            this.urlLaunchButton.setEnabled(false);
            this.urlLaunchButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (OptionsExtensionPanel.this.extURL.getText() != null) {
                        DesktopUtils.openUrlInBrowser(OptionsExtensionPanel.this.extURL.getText());
                    }
                }
            });
        }
        return this.urlLaunchButton;
    }

    private JScrollPane getExtDescJScrollPane() {
        if (this.extDescScrollPane == null) {
            this.extDescScrollPane = new JScrollPane();
            this.extDescScrollPane.setViewportView(this.extDescription);
            this.extDescription.setEditable(false);
            this.extDescription.setLineWrap(true);
        }
        return this.extDescScrollPane;
    }

    private OptionsExtensionTableModel getExtensionModel() {
        if (this.extensionModel == null) {
            this.extensionModel = new OptionsExtensionTableModel();
        }
        return this.extensionModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.ext";
    }
}

