/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.forceduser;

import com.stackhawk.hste.extension.api.ApiAction;
import com.stackhawk.hste.extension.api.ApiException;
import com.stackhawk.hste.extension.api.ApiImplementor;
import com.stackhawk.hste.extension.api.ApiResponse;
import com.stackhawk.hste.extension.api.ApiResponseElement;
import com.stackhawk.hste.extension.api.ApiView;
import com.stackhawk.hste.extension.forceduser.ExtensionForcedUser;
import com.stackhawk.hste.model.Context;
import com.stackhawk.hste.users.User;
import com.stackhawk.hste.utils.ApiUtils;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForcedUserAPI
extends ApiImplementor {
    private static final Logger LOGGER = LogManager.getLogger(ForcedUserAPI.class);
    private static final String PREFIX = "forcedUser";
    private static final String VIEW_GET_FORCED_USER = "getForcedUser";
    private static final String VIEW_IS_FORCED_USER_MODE_ENABLED = "isForcedUserModeEnabled";
    private static final String ACTION_SET_FORCED_USER = "setForcedUser";
    private static final String ACTION_SET_FORCED_USER_MODE_ENABLED = "setForcedUserModeEnabled";
    private static final String PARAM_USER_ID = "userId";
    private static final String PARAM_CONTEXT_ID = "contextId";
    private static final String PARAM_MODE_ENABLED = "boolean";
    private ExtensionForcedUser extension;

    public ForcedUserAPI(ExtensionForcedUser extension) {
        this.extension = extension;
        this.addApiView(new ApiView(VIEW_IS_FORCED_USER_MODE_ENABLED));
        this.addApiView(new ApiView(VIEW_GET_FORCED_USER, new String[]{PARAM_CONTEXT_ID}));
        this.addApiAction(new ApiAction(ACTION_SET_FORCED_USER, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}));
        this.addApiAction(new ApiAction(ACTION_SET_FORCED_USER_MODE_ENABLED, new String[]{PARAM_MODE_ENABLED}));
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        LOGGER.debug("handleApiView {} {}", (Object)name, (Object)params);
        switch (name) {
            case "getForcedUser": {
                Context context = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
                User forcedUser = this.extension.getForcedUser(context.getId());
                if (forcedUser != null) {
                    return new ApiResponseElement("forcedUserId", Integer.toString(forcedUser.getId()));
                }
                return new ApiResponseElement("forcedUserId", "");
            }
            case "isForcedUserModeEnabled": {
                return new ApiResponseElement("forcedModeEnabled", Boolean.toString(this.extension.isForcedUserModeEnabled()));
            }
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        LOGGER.debug("handleApiAction {} {}", (Object)name, (Object)params);
        switch (name) {
            case "setForcedUser": {
                Context context = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
                int userId = ApiUtils.getIntParam(params, PARAM_USER_ID);
                try {
                    this.extension.setForcedUser(context.getId(), userId);
                }
                catch (IllegalStateException ex) {
                    throw new ApiException(ApiException.Type.USER_NOT_FOUND);
                }
                context.save();
                return ApiResponseElement.OK;
            }
            case "setForcedUserModeEnabled": {
                boolean newModeStatus;
                if (!params.containsKey((Object)PARAM_MODE_ENABLED)) {
                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_MODE_ENABLED);
                }
                try {
                    newModeStatus = params.getBoolean(PARAM_MODE_ENABLED);
                }
                catch (JSONException ex) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_MODE_ENABLED);
                }
                this.extension.setForcedUserModeEnabled(newModeStatus);
                return ApiResponseElement.OK;
            }
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }
}

