/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.globalexcludeurl;

import com.stackhawk.hste.extension.globalexcludeurl.GlobalExcludeURLParamToken;
import com.stackhawk.hste.utils.HsteTextField;
import com.stackhawk.hste.view.AbstractFormDialog;
import java.awt.Dialog;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.parosproxy.paros.Constant;

@Deprecated(since="2.13.0", forRemoval=true)
class DialogAddToken
extends AbstractFormDialog {
    private static final long serialVersionUID = 4460797449668634319L;
    private static final String DIALOG_TITLE = Constant.messages.getString("options.globalexcludeurl.dialog.token.add.title");
    private static final String CONFIRM_BUTTON_LABEL = Constant.messages.getString("options.globalexcludeurl.dialog.token.add.button.confirm");
    private static final String NAME_FIELD_LABEL = Constant.messages.getString("options.globalexcludeurl.dialog.token.field.label.name");
    private static final String ENABLED_FIELD_LABEL = Constant.messages.getString("options.globalexcludeurl.dialog.token.field.label.enabled");
    private static final String DESC_FIELD_LABEL = Constant.messages.getString("options.globalexcludeurl.dialog.token.field.label.description");
    private static final String TITLE_NAME_REPEATED_DIALOG = Constant.messages.getString("options.globalexcludeurl.dialog.token.warning.name.repeated.title");
    private static final String TEXT_NAME_REPEATED_DIALOG = Constant.messages.getString("options.globalexcludeurl.dialog.token.warning.name.repeated.text");
    private HsteTextField regexTextField;
    private JCheckBox enabledCheckBox;
    private HsteTextField descTextField;
    protected GlobalExcludeURLParamToken token;
    private List<GlobalExcludeURLParamToken> tokens;

    public DialogAddToken(Dialog owner) {
        super(owner, DIALOG_TITLE);
    }

    protected DialogAddToken(Dialog owner, String title) {
        super(owner, title);
    }

    @Override
    protected JPanel getFieldsPanel() {
        JPanel fieldsPanel = new JPanel();
        GroupLayout layout = new GroupLayout(fieldsPanel);
        fieldsPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JLabel nameLabel = new JLabel(NAME_FIELD_LABEL);
        JLabel enabledLabel = new JLabel(ENABLED_FIELD_LABEL);
        JLabel descLabel = new JLabel(DESC_FIELD_LABEL);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(nameLabel).addComponent(enabledLabel).addComponent(descLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getRegexTextField()).addComponent(this.getEnabledCheckBox()).addComponent(this.getDescTextField())));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(nameLabel).addComponent(this.getRegexTextField())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(enabledLabel).addComponent(this.getEnabledCheckBox())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(descLabel).addComponent(this.getDescTextField())));
        return fieldsPanel;
    }

    @Override
    protected String getConfirmButtonLabel() {
        return CONFIRM_BUTTON_LABEL;
    }

    @Override
    protected void init() {
        this.getRegexTextField().setText("");
        this.getEnabledCheckBox().setSelected(true);
        this.getDescTextField().setText("");
        this.token = null;
    }

    @Override
    protected boolean validateFields() {
        String tokenName = this.getRegexTextField().getText();
        for (GlobalExcludeURLParamToken t : this.tokens) {
            if (!tokenName.equals(t.getRegex())) continue;
            JOptionPane.showMessageDialog(this, TEXT_NAME_REPEATED_DIALOG, TITLE_NAME_REPEATED_DIALOG, 1);
            this.getRegexTextField().requestFocusInWindow();
            return false;
        }
        return true;
    }

    @Override
    protected void performAction() {
        this.token = new GlobalExcludeURLParamToken(this.getRegexTextField().getText(), this.getDescTextField().getText(), this.getEnabledCheckBox().isSelected());
    }

    @Override
    protected void clearFields() {
        this.getRegexTextField().setText("");
        this.getRegexTextField().discardAllEdits();
        this.getDescTextField().setText("");
        this.getDescTextField().discardAllEdits();
    }

    public GlobalExcludeURLParamToken getToken() {
        return this.token;
    }

    protected HsteTextField getRegexTextField() {
        if (this.regexTextField == null) {
            this.regexTextField = new HsteTextField(25);
            this.regexTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.checkAndEnableConfirmButton();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.checkAndEnableConfirmButton();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.checkAndEnableConfirmButton();
                }

                private void checkAndEnableConfirmButton() {
                    DialogAddToken.this.setConfirmButtonEnabled(DialogAddToken.this.getRegexTextField().getDocument().getLength() > 0);
                }
            });
        }
        return this.regexTextField;
    }

    protected JCheckBox getEnabledCheckBox() {
        if (this.enabledCheckBox == null) {
            this.enabledCheckBox = new JCheckBox();
        }
        return this.enabledCheckBox;
    }

    protected HsteTextField getDescTextField() {
        if (this.descTextField == null) {
            this.descTextField = new HsteTextField(25);
            this.descTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.checkAndEnableConfirmButton();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.checkAndEnableConfirmButton();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.checkAndEnableConfirmButton();
                }

                private void checkAndEnableConfirmButton() {
                    DialogAddToken.this.setConfirmButtonEnabled(DialogAddToken.this.getDescTextField().getDocument().getLength() > 0);
                }
            });
        }
        return this.descTextField;
    }

    public void setTokens(List<GlobalExcludeURLParamToken> tokens) {
        this.tokens = tokens;
    }

    public void clear() {
        this.tokens = null;
        this.token = null;
    }
}

