/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.help;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.help.JHelpContentViewer;
import javax.help.plaf.basic.BasicContentViewerUI;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicOnlineContentViewerUI
extends BasicContentViewerUI {
    private static final Logger LOGGER = LogManager.getLogger(BasicOnlineContentViewerUI.class);
    private static final long serialVersionUID = -1640590425627589113L;

    public BasicOnlineContentViewerUI(JHelpContentViewer contentViewer) {
        super(contentViewer);
    }

    protected void linkActivated(URL u) {
        String protocol = u.getProtocol();
        if (Desktop.isDesktopSupported() && ("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol))) {
            try {
                Desktop.getDesktop().browse(u.toURI());
            }
            catch (IOException | URISyntaxException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        } else {
            super.linkActivated(u);
        }
    }

    public static ComponentUI createUI(JComponent x) {
        return new BasicOnlineContentViewerUI((JHelpContentViewer)x);
    }
}

