/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.help;

import com.stackhawk.hste.extension.help.HsteTocItem;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.TOCView;
import javax.help.TreeItem;
import javax.help.TreeItemFactory;
import javax.swing.tree.DefaultMutableTreeNode;

public class HsteTocView
extends TOCView {
    private static final long serialVersionUID = 8473218435547565830L;

    public HsteTocView(HelpSet hs, String name, String label, Hashtable<?, ?> params) {
        this(hs, name, label, hs.getLocale(), params);
    }

    public HsteTocView(HelpSet hs, String name, String label, Locale locale, Hashtable<?, ?> params) {
        super(hs, name, label, locale, params);
    }

    public DefaultMutableTreeNode getDataAsTree() {
        URL url;
        HelpSet hs = this.getHelpSet();
        Hashtable params = this.getParameters();
        if (params == null || !params.containsKey("data")) {
            return new DefaultMutableTreeNode();
        }
        try {
            url = new URL(hs.getHelpSetURL(), (String)params.get("data"));
        }
        catch (Exception ex) {
            throw new Error("Trouble getting URL to TOC data; " + String.valueOf(ex));
        }
        return HsteTocView.parse((URL)url, (HelpSet)hs, (Locale)hs.getLocale(), (TreeItemFactory)new TreeItemFactoryImpl(), (TOCView)this);
    }

    private static class TreeItemFactoryImpl
    extends TOCView.DefaultTOCFactory {
        private TreeItemFactoryImpl() {
        }

        public TreeItem createItem(String tagName, Hashtable atts, HelpSet hs, Locale locale) {
            if (tagName == null || !tagName.equals("tocitem")) {
                throw new IllegalArgumentException("tagName");
            }
            String id = null;
            String imageID = null;
            String text = null;
            String mergeType = null;
            String expand = null;
            String presentation = null;
            String presentationName = null;
            String tocid = null;
            if (atts != null) {
                id = (String)atts.get("target");
                imageID = (String)atts.get("image");
                text = (String)atts.get("text");
                mergeType = (String)atts.get("mergetype");
                expand = (String)atts.get("expand");
                presentation = (String)atts.get("presentationtype");
                presentationName = (String)atts.get("presentationname");
                tocid = (String)atts.get("tocid");
            }
            Map.ID mapID = null;
            Map.ID imageMapID = null;
            try {
                mapID = Map.ID.create((String)id, (HelpSet)hs);
            }
            catch (BadIDException badIDException) {
                // empty catch block
            }
            try {
                imageMapID = Map.ID.create((String)imageID, (HelpSet)hs);
            }
            catch (BadIDException badIDException) {
                // empty catch block
            }
            HsteTocItem item = new HsteTocItem(mapID, imageMapID, hs, locale, tocid);
            if (text != null) {
                item.setName(text);
            }
            if (mergeType != null) {
                item.setMergeType(mergeType);
            }
            if (expand != null) {
                if (expand.equals("true")) {
                    item.setExpansionType(1);
                } else if (expand.equals("false")) {
                    item.setExpansionType(0);
                }
            }
            if (presentation != null) {
                item.setPresentation(presentation);
            }
            if (presentationName != null) {
                item.setPresentationName(presentationName);
            }
            return item;
        }
    }
}

