/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.history;

import com.stackhawk.hste.utils.HsteLabel;
import com.stackhawk.hste.view.LayoutHelper;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.extension.history.HistoryFilter;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpStatusCode;
import org.parosproxy.paros.view.View;

public class HistoryFilterPlusDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private JButton btnApply = null;
    private JButton btnCancel = null;
    private JPanel jPanel1 = null;
    private int exitResult = 2;
    private HistoryFilter filter = new HistoryFilter();
    private JButton btnReset = null;
    private JPanel jPanel2 = null;
    private JList<String> methodList = null;
    private JList<Integer> codeList = null;
    private JList<String> riskList = null;
    private JList<String> confidenceList = null;
    private JList<String> tagList = null;
    private JTextArea regexInc = null;
    private JTextArea regexExc = null;
    private DefaultListModel<String> tagModel = null;
    private JScrollPane methodScroller = null;
    private JScrollPane codeScroller = null;
    private JScrollPane tagScroller = null;
    private JScrollPane riskScroller = null;
    private JScrollPane confidenceScroller = null;
    private JComboBox<String> notesComboBox = null;
    private JScrollPane urlRegxIncScroller = null;
    private JScrollPane urlRegxExcScroller = null;

    public HistoryFilterPlusDialog() throws HeadlessException {
        this.initialize();
    }

    public HistoryFilterPlusDialog(Frame arg0, boolean arg1) throws HeadlessException {
        super(arg0, arg1);
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJPanel());
        this.setVisible(false);
        this.setTitle(Constant.messages.getString("history.filter.title"));
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(600, 300);
        }
        this.centreDialog();
        this.getRootPane().setDefaultButton(this.btnApply);
        this.pack();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            HsteLabel descLabel = new HsteLabel();
            descLabel.setLineWrap(true);
            descLabel.setWrapStyleWord(true);
            descLabel.setText(Constant.messages.getString("history.filter.label.desc"));
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            gridBagConstraints6.gridwidth = 3;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 3;
            gridBagConstraints6.insets = new Insets(5, 2, 5, 2);
            gridBagConstraints6.ipadx = 3;
            gridBagConstraints6.ipady = 3;
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridy = 0;
            gridBagConstraints11.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.gridwidth = 3;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.ipadx = 3;
            gridBagConstraints11.ipady = 3;
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.weighty = 1.0;
            gridBagConstraints12.gridwidth = 3;
            gridBagConstraints12.gridy = 2;
            gridBagConstraints12.fill = 1;
            gridBagConstraints12.insets = new Insets(2, 10, 2, 10);
            gridBagConstraints12.ipadx = 0;
            gridBagConstraints12.ipady = 1;
            this.jPanel.add((Component)descLabel, gridBagConstraints11);
            this.jPanel.add((Component)this.getJPanel2(), gridBagConstraints12);
            this.jPanel.add((Component)this.getJPanel1(), gridBagConstraints6);
        }
        return this.jPanel;
    }

    private JButton getBtnApply() {
        if (this.btnApply == null) {
            this.btnApply = new JButton();
            this.btnApply.setText(Constant.messages.getString("history.filter.button.apply"));
            this.btnApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        HistoryFilterPlusDialog.this.filter.setMethods(HistoryFilterPlusDialog.this.methodList.getSelectedValuesList());
                        HistoryFilterPlusDialog.this.filter.setCodes(HistoryFilterPlusDialog.this.codeList.getSelectedValuesList());
                        HistoryFilterPlusDialog.this.filter.setTags(HistoryFilterPlusDialog.this.tagList.getSelectedValuesList());
                        HistoryFilterPlusDialog.this.filter.setRisks(HistoryFilterPlusDialog.this.riskList.getSelectedValuesList());
                        HistoryFilterPlusDialog.this.filter.setReliabilities(HistoryFilterPlusDialog.this.confidenceList.getSelectedValuesList());
                        HistoryFilterPlusDialog.this.filter.setNote(HistoryFilterPlusDialog.this.notesComboBox.getSelectedItem());
                        HistoryFilterPlusDialog.this.filter.setUrlIncPatternList(HistoryFilterPlusDialog.this.strToRegexList(HistoryFilterPlusDialog.this.regexInc.getText()));
                        HistoryFilterPlusDialog.this.filter.setUrlExcPatternList(HistoryFilterPlusDialog.this.strToRegexList(HistoryFilterPlusDialog.this.regexExc.getText()));
                        HistoryFilterPlusDialog.this.exitResult = 0;
                        HistoryFilterPlusDialog.this.dispose();
                    }
                    catch (PatternSyntaxException e1) {
                        View.getSingleton().showWarningDialog(Constant.messages.getString("history.filter.badregex.warning", e1.getMessage()));
                    }
                }
            });
        }
        return this.btnApply;
    }

    private List<Pattern> strToRegexList(String str) throws PatternSyntaxException {
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        for (String s : str.split("\n")) {
            if (s.length() <= 0) continue;
            list.add(Pattern.compile(s));
        }
        return list;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(Constant.messages.getString("all.button.cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HistoryFilterPlusDialog.this.exitResult = 2;
                    HistoryFilterPlusDialog.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.add((Component)this.getBtnCancel(), null);
            this.jPanel1.add((Component)this.getBtnReset(), null);
            this.jPanel1.add((Component)this.getBtnApply(), null);
        }
        return this.jPanel1;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.exitResult;
    }

    private JButton getBtnReset() {
        if (this.btnReset == null) {
            this.btnReset = new JButton();
            this.btnReset.setText(Constant.messages.getString("history.filter.button.clear"));
            this.btnReset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HistoryFilterPlusDialog.this.exitResult = 1;
                    HistoryFilterPlusDialog.this.methodList.setSelectedIndices(new int[0]);
                    HistoryFilterPlusDialog.this.codeList.setSelectedIndices(new int[0]);
                    HistoryFilterPlusDialog.this.tagList.setSelectedIndices(new int[0]);
                    HistoryFilterPlusDialog.this.riskList.setSelectedIndices(new int[0]);
                    HistoryFilterPlusDialog.this.confidenceList.setSelectedIndices(new int[0]);
                    HistoryFilterPlusDialog.this.notesComboBox.setSelectedItem(HistoryFilter.NOTES_IGNORE);
                    HistoryFilterPlusDialog.this.regexInc.setText("");
                    HistoryFilterPlusDialog.this.regexExc.setText("");
                    HistoryFilterPlusDialog.this.filter.reset();
                }
            });
        }
        return this.btnReset;
    }

    private Insets stdInset() {
        return new Insets(5, 5, 1, 5);
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gbc00 = LayoutHelper.getGBC(0, 0, 1, 1.0, this.stdInset());
            GridBagConstraints gbc01 = LayoutHelper.getGBC(1, 0, 1, 1.0, this.stdInset());
            GridBagConstraints gbc02 = LayoutHelper.getGBC(2, 0, 1, 1.0, this.stdInset());
            GridBagConstraints gbc03 = LayoutHelper.getGBC(3, 0, 1, 1.0, this.stdInset());
            GridBagConstraints gbc04 = LayoutHelper.getGBC(4, 0, 1, 1.0, this.stdInset());
            GridBagConstraints gbc10 = LayoutHelper.getGBC(0, 1, 1, 3, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gbc11 = LayoutHelper.getGBC(1, 1, 1, 3, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gbc12 = LayoutHelper.getGBC(2, 1, 1, 3, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gbc13 = LayoutHelper.getGBC(3, 1, 1, 2, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gbc14 = LayoutHelper.getGBC(4, 1, 1, 1, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gbc24 = LayoutHelper.getGBC(4, 2, 1, 1, 0.0, 0.0, 0, 18, this.stdInset());
            GridBagConstraints gbc33 = LayoutHelper.getGBC(3, 3, 1, 1, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gbc34 = LayoutHelper.getGBC(4, 3, 1, 1, 0.0, 0.0, 1, 18, this.stdInset());
            GridBagConstraints gbc30 = LayoutHelper.getGBC(0, 4, 2, 1.0, this.stdInset());
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("history.filter.label.methods")), gbc00);
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("history.filter.label.codes")), gbc01);
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("history.filter.label.tags")), gbc02);
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("history.filter.label.alerts")), gbc03);
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("history.filter.label.urlincregex")), gbc04);
            this.jPanel2.add((Component)this.getMethodScroller(), gbc10);
            this.jPanel2.add((Component)this.getCodeScroller(), gbc11);
            this.jPanel2.add((Component)this.getTagScroller(), gbc12);
            this.jPanel2.add((Component)this.getRiskScroller(), gbc13);
            this.jPanel2.add((Component)this.getUrlRegxIncScroller(), gbc14);
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("history.filter.label.urlexcregex")), gbc24);
            this.jPanel2.add((Component)this.getConfidenceScroller(), gbc33);
            this.jPanel2.add((Component)this.getUrlRegxExcScroller(), gbc34);
            this.getUrlRegxExcScroller();
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.add(new JLabel(Constant.messages.getString("history.filter.label.notes")));
            jPanel3.add(this.getNotesComboBox());
            this.jPanel2.add((Component)jPanel3, gbc30);
        }
        return this.jPanel2;
    }

    private JScrollPane getMethodScroller() {
        if (this.methodScroller == null) {
            this.methodList = new JList<String>(HttpRequestHeader.METHODS);
            this.methodList.setSelectionMode(2);
            this.methodList.setLayoutOrientation(0);
            this.methodList.setVisibleRowCount(HttpRequestHeader.METHODS.length);
            this.methodScroller = new JScrollPane(this.methodList);
        }
        return this.methodScroller;
    }

    private JScrollPane getCodeScroller() {
        if (this.codeScroller == null) {
            Vector<Integer> codeInts = new Vector<Integer>(HttpStatusCode.CODES.length);
            for (int i : HttpStatusCode.CODES) {
                codeInts.add(i);
            }
            this.codeList = new JList(codeInts);
            this.codeList.setSelectionMode(2);
            this.codeList.setLayoutOrientation(0);
            this.codeScroller = new JScrollPane(this.codeList);
        }
        return this.codeScroller;
    }

    private JScrollPane getRiskScroller() {
        if (this.riskScroller == null) {
            this.riskList = new JList<String>(Alert.MSG_RISK);
            this.riskList.setSelectionMode(2);
            this.riskList.setLayoutOrientation(0);
            this.riskList.setVisibleRowCount(Alert.MSG_RISK.length);
            this.riskScroller = new JScrollPane(this.riskList);
        }
        return this.riskScroller;
    }

    private JScrollPane getConfidenceScroller() {
        if (this.confidenceScroller == null) {
            this.confidenceList = new JList<String>(Alert.MSG_CONFIDENCE);
            this.confidenceList.setSelectionMode(2);
            this.confidenceList.setLayoutOrientation(0);
            this.confidenceList.setVisibleRowCount(Alert.MSG_CONFIDENCE.length);
            this.confidenceScroller = new JScrollPane(this.confidenceList);
        }
        return this.confidenceScroller;
    }

    private JScrollPane getUrlRegxIncScroller() {
        if (this.urlRegxIncScroller == null) {
            this.regexInc = new JTextArea();
            this.regexInc.setRows(4);
            this.urlRegxIncScroller = new JScrollPane(this.regexInc);
        }
        return this.urlRegxIncScroller;
    }

    private JScrollPane getUrlRegxExcScroller() {
        if (this.urlRegxExcScroller == null) {
            this.regexExc = new JTextArea();
            this.regexExc.setRows(5);
            this.urlRegxExcScroller = new JScrollPane(this.regexExc);
        }
        return this.urlRegxExcScroller;
    }

    private DefaultListModel<String> getTagModel() {
        if (this.tagModel == null) {
            this.tagModel = new DefaultListModel();
        }
        return this.tagModel;
    }

    private JScrollPane getTagScroller() {
        if (this.tagScroller == null) {
            this.tagList = new JList<String>(this.getTagModel());
            this.tagList.setPrototypeCellValue("Tags are short...");
            this.tagScroller = new JScrollPane(this.tagList);
            this.tagScroller.setHorizontalScrollBarPolicy(30);
            this.tagScroller.setVerticalScrollBarPolicy(20);
        }
        return this.tagScroller;
    }

    private JComboBox<String> getNotesComboBox() {
        if (this.notesComboBox == null) {
            this.notesComboBox = new JComboBox<String>(HistoryFilter.NOTES_OPTIONS);
        }
        return this.notesComboBox;
    }

    public void setAllTags(List<String> allTags) {
        List<String> selected = this.tagList.getSelectedValuesList();
        int[] inds = new int[allTags.size()];
        Arrays.fill(inds, -1);
        this.getTagModel().clear();
        int i = 0;
        for (String tag : allTags) {
            this.getTagModel().addElement(tag);
        }
        for (String sel : selected) {
            if (this.getTagModel().contains(sel)) {
                inds[i] = this.getTagModel().indexOf(sel);
            }
            ++i;
        }
        this.tagList.setSelectedIndices(inds);
    }

    public HistoryFilter getFilter() {
        return this.filter;
    }
}

