/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.history;

import com.stackhawk.hste.utils.HsteTextArea;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;

public class NotesAddDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private HsteTextArea txtDisplay = null;
    private JButton btnOk = null;
    private JButton btnCancel = null;
    private HistoryReference historyRef;
    private JScrollPane jScrollPane = null;

    public NotesAddDialog() throws HeadlessException {
        this.initialize();
    }

    public NotesAddDialog(Frame arg0, boolean arg1) throws HeadlessException {
        super(arg0, arg1);
        this.initialize();
    }

    private void initialize() {
        this.setTitle(Constant.messages.getString("history.addnote.title"));
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        Component buttonsGlue = Box.createHorizontalGlue();
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.getJScrollPane()).addGroup(layout.createSequentialGroup().addComponent(buttonsGlue, -1, -2, -1).addComponent(this.getBtnCancel()).addComponent(this.getBtnOk())));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getJScrollPane()).addGroup(layout.createParallelGroup().addComponent(buttonsGlue).addComponent(this.getBtnCancel()).addComponent(this.getBtnOk())));
        this.setContentPane(panel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NotesAddDialog.this.clearAndDispose();
            }
        });
        this.pack();
    }

    private HsteTextArea getTxtDisplay() {
        if (this.txtDisplay == null) {
            this.txtDisplay = new HsteTextArea("", 15, 25);
        }
        return this.txtDisplay;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setText(Constant.messages.getString("all.button.save"));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotesAddDialog.this.historyRef.setNote(NotesAddDialog.this.getTxtDisplay().getText());
                    NotesAddDialog.this.clearAndDispose();
                }
            });
        }
        return this.btnOk;
    }

    private void clearAndDispose() {
        this.setNote("");
        this.historyRef = null;
        this.dispose();
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(Constant.messages.getString("all.button.cancel"));
            this.btnCancel.addActionListener(e -> this.clearAndDispose());
        }
        return this.btnCancel;
    }

    @Deprecated
    public void setPlugin(ExtensionHistory plugin) {
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(30);
            this.jScrollPane.setVerticalScrollBarPolicy(20);
            this.jScrollPane.setViewportView(this.getTxtDisplay());
        }
        return this.jScrollPane;
    }

    public HistoryReference getHistoryRef() {
        return this.historyRef;
    }

    public void setHistoryRef(HistoryReference historyRef) {
        this.historyRef = historyRef;
    }

    public void setNote(String note) {
        this.getTxtDisplay().setText(note);
        this.getTxtDisplay().discardAllEdits();
    }
}

