/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httppanel.component.all.request;

import com.stackhawk.hste.extension.httppanel.view.impl.models.http.request.RequestStringHttpPanelViewModel;
import com.stackhawk.hste.extension.httppanel.view.text.HttpPanelTextArea;
import com.stackhawk.hste.extension.httppanel.view.text.HttpPanelTextView;
import com.stackhawk.hste.extension.httppanel.view.util.HttpTextViewUtils;
import com.stackhawk.hste.extension.search.SearchMatch;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.parosproxy.paros.network.HttpMessage;

public class HttpRequestAllPanelTextView
extends HttpPanelTextView {
    public HttpRequestAllPanelTextView(RequestStringHttpPanelViewModel model) {
        super(model);
    }

    @Override
    protected HttpPanelTextArea createHttpPanelTextArea() {
        return new HttpRequestAllPanelTextArea();
    }

    protected static class HttpRequestAllPanelTextArea
    extends HttpPanelTextArea {
        private static final long serialVersionUID = 6236551060576387786L;

        protected HttpRequestAllPanelTextArea() {
        }

        @Override
        public void search(Pattern p, List<SearchMatch> matches) {
            String header = ((HttpMessage)this.getMessage()).getRequestHeader().toString();
            Matcher m = p.matcher(this.getText());
            while (m.find()) {
                int[] position = HttpTextViewUtils.getViewToHeaderBodyPosition(this, header, m.start(), m.end());
                if (position.length == 0) {
                    return;
                }
                SearchMatch.Location location = position.length == 2 ? SearchMatch.Location.REQUEST_HEAD : SearchMatch.Location.REQUEST_BODY;
                matches.add(new SearchMatch(location, position[0], position[1]));
            }
        }

        @Override
        public void highlight(SearchMatch sm) {
            if (!SearchMatch.Location.REQUEST_HEAD.equals((Object)sm.getLocation()) && !SearchMatch.Location.REQUEST_BODY.equals((Object)sm.getLocation())) {
                return;
            }
            int[] pos = SearchMatch.Location.REQUEST_HEAD.equals((Object)sm.getLocation()) ? HttpTextViewUtils.getHeaderToViewPosition(this, sm.getMessage().getRequestHeader().toString(), sm.getStart(), sm.getEnd()) : HttpTextViewUtils.getBodyToViewPosition(this, sm.getMessage().getRequestHeader().toString(), sm.getStart(), sm.getEnd());
            if (pos.length == 0) {
                return;
            }
            this.highlight(pos[0], pos[1]);
        }
    }
}

