/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httppanel.component.split.request;

import com.stackhawk.hste.extension.httppanel.view.impl.models.http.request.RequestHeaderStringHttpPanelViewModel;
import com.stackhawk.hste.extension.httppanel.view.text.HttpPanelTextArea;
import com.stackhawk.hste.extension.httppanel.view.text.HttpPanelTextView;
import com.stackhawk.hste.extension.httppanel.view.util.HttpTextViewUtils;
import com.stackhawk.hste.extension.search.SearchMatch;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpRequestHeaderPanelTextView
extends HttpPanelTextView {
    public HttpRequestHeaderPanelTextView(RequestHeaderStringHttpPanelViewModel model) {
        super(model);
    }

    @Override
    protected HttpPanelTextArea createHttpPanelTextArea() {
        return new HttpRequestHeaderPanelTextArea();
    }

    private static class HttpRequestHeaderPanelTextArea
    extends HttpPanelTextArea {
        private static final long serialVersionUID = 985537589818833350L;

        private HttpRequestHeaderPanelTextArea() {
        }

        @Override
        public void search(Pattern p, List<SearchMatch> matches) {
            Matcher m = p.matcher(this.getText());
            while (m.find()) {
                int[] position = HttpTextViewUtils.getViewToHeaderPosition(this, m.start(), m.end());
                if (position.length == 0) {
                    return;
                }
                matches.add(new SearchMatch(SearchMatch.Location.REQUEST_HEAD, position[0], position[1]));
            }
        }

        @Override
        public void highlight(SearchMatch sm) {
            if (!SearchMatch.Location.REQUEST_HEAD.equals((Object)sm.getLocation())) {
                return;
            }
            int[] pos = HttpTextViewUtils.getHeaderToViewPosition(this, sm.getMessage().getRequestHeader().toString(), sm.getStart(), sm.getEnd());
            if (pos.length == 0) {
                return;
            }
            this.highlight(pos[0], pos[1]);
        }
    }
}

