/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httppanel.view.image;

import com.stackhawk.hste.extension.httppanel.Message;
import com.stackhawk.hste.extension.httppanel.component.split.request.RequestSplitComponent;
import com.stackhawk.hste.extension.httppanel.view.DefaultHttpPanelViewModel;
import com.stackhawk.hste.extension.httppanel.view.HttpPanelDefaultViewSelector;
import com.stackhawk.hste.extension.httppanel.view.HttpPanelView;
import com.stackhawk.hste.extension.httppanel.view.image.ResponseImageView;
import com.stackhawk.hste.view.HttpPanelManager;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;

public class ExtensionHttpPanelImageView
extends ExtensionAdaptor {
    public static final String NAME = "ExtensionHttpPanelImageView";

    public ExtensionHttpPanelImageView() {
        super(NAME);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("http.panel.view.image.ext.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            HttpPanelManager panelManager = HttpPanelManager.getInstance();
            panelManager.addResponseViewFactory("ResponseSplit", new ResponseImageViewFactory());
            panelManager.addResponseDefaultViewSelectorFactory("ResponseSplit", new ResponseImageViewDefaultViewSelectorFactory());
        }
    }

    @Override
    public boolean canUnload() {
        return false;
    }

    @Override
    public void unload() {
        if (this.getView() != null) {
            HttpPanelManager panelManager = HttpPanelManager.getInstance();
            panelManager.removeResponseViewFactory("ResponseSplit", "ResponseImageViewFactory");
            panelManager.removeResponseViews("ResponseSplit", "ResponseImageView", (Object)RequestSplitComponent.ViewComponent.BODY);
            panelManager.removeResponseDefaultViewSelectorFactory("ResponseSplit", "ResponseImageViewDefaultViewSelectorFactory");
            panelManager.removeResponseDefaultViewSelectors("ResponseSplit", "ResponseImageViewDefaultViewSelector", (Object)RequestSplitComponent.ViewComponent.BODY);
        }
    }

    @Override
    public String getAuthor() {
        return "HSTE Dev Team";
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    private static final class ResponseImageViewFactory
    implements HttpPanelManager.HttpPanelViewFactory {
        public static final String NAME = "ResponseImageViewFactory";

        private ResponseImageViewFactory() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public HttpPanelView getNewView() {
            return new ResponseImageView(new DefaultHttpPanelViewModel());
        }

        @Override
        public Object getOptions() {
            return RequestSplitComponent.ViewComponent.BODY;
        }
    }

    private static final class ResponseImageViewDefaultViewSelectorFactory
    implements HttpPanelManager.HttpPanelDefaultViewSelectorFactory {
        private static HttpPanelDefaultViewSelector defaultViewSelector = null;
        public static final String NAME = "ResponseImageViewDefaultViewSelectorFactory";

        private ResponseImageViewDefaultViewSelectorFactory() {
        }

        private HttpPanelDefaultViewSelector getDefaultViewSelector() {
            if (defaultViewSelector == null) {
                this.createViewSelector();
            }
            return defaultViewSelector;
        }

        private synchronized void createViewSelector() {
            if (defaultViewSelector == null) {
                defaultViewSelector = new ResponseImageViewDefaultViewSelector();
            }
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public HttpPanelDefaultViewSelector getNewDefaultViewSelector() {
            return this.getDefaultViewSelector();
        }

        @Override
        public Object getOptions() {
            return RequestSplitComponent.ViewComponent.BODY;
        }
    }

    private static final class ResponseImageViewDefaultViewSelector
    implements HttpPanelDefaultViewSelector {
        public static final String NAME = "ResponseImageViewDefaultViewSelector";

        private ResponseImageViewDefaultViewSelector() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public boolean matchToDefaultView(Message aMessage) {
            return ResponseImageView.isImage(aMessage);
        }

        @Override
        public String getViewName() {
            return "ResponseImageView";
        }

        @Override
        public int getOrder() {
            return 20;
        }
    }
}

