/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httppanel.view.impl.models.http.request;

import com.stackhawk.hste.extension.httppanel.InvalidMessageDataException;
import com.stackhawk.hste.extension.httppanel.view.impl.models.http.AbstractHttpByteHttpPanelViewModel;
import com.stackhawk.hste.extension.httppanel.view.impl.models.http.HttpPanelViewModelUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class RequestByteHttpPanelViewModel
extends AbstractHttpByteHttpPanelViewModel {
    private static final Logger LOGGER = LogManager.getLogger(RequestByteHttpPanelViewModel.class);

    @Override
    public byte[] getData() {
        if (this.httpMessage == null) {
            return new byte[0];
        }
        byte[] headerBytes = this.httpMessage.getRequestHeader().toString().getBytes();
        byte[] bodyBytes = this.httpMessage.getRequestBody().getBytes();
        byte[] bytes = new byte[headerBytes.length + bodyBytes.length];
        System.arraycopy(headerBytes, 0, bytes, 0, headerBytes.length);
        System.arraycopy(bodyBytes, 0, bytes, headerBytes.length, bodyBytes.length);
        return bytes;
    }

    @Override
    public void setData(byte[] data) {
        if (this.httpMessage == null) {
            return;
        }
        int pos = HttpPanelViewModelUtils.findHeaderLimit(data);
        if (pos == -1) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Could not Save Header, limit not found. Header: {}", (Object)new String(data));
            }
            throw new InvalidMessageDataException(Constant.messages.getString("http.panel.model.header.warn.notfound"));
        }
        try {
            this.httpMessage.setRequestHeader(new String(data, 0, pos));
        }
        catch (HttpMalformedHeaderException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Could not Save Header: {}", (Object)new String(data, 0, pos), (Object)e);
            }
            throw new InvalidMessageDataException(Constant.messages.getString("http.panel.model.header.warn.malformed"), e);
        }
        this.httpMessage.getRequestBody().setBody(ArrayUtils.subarray((byte[])data, (int)pos, (int)data.length));
    }
}

