/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httppanel.view.impl.models.http.request;

import com.stackhawk.hste.extension.httppanel.InvalidMessageDataException;
import com.stackhawk.hste.extension.httppanel.view.impl.models.http.AbstractHttpStringHttpPanelViewModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class RequestHeaderStringHttpPanelViewModel
extends AbstractHttpStringHttpPanelViewModel {
    private static final Logger LOGGER = LogManager.getLogger(RequestHeaderStringHttpPanelViewModel.class);

    @Override
    public String getData() {
        if (this.httpMessage == null) {
            return "";
        }
        return this.httpMessage.getRequestHeader().toString().replaceAll("\r\n", "\n");
    }

    @Override
    public void setData(String data) {
        if (this.httpMessage == null) {
            return;
        }
        String header = data.replaceAll("(?<!\r)\n", "\r\n");
        try {
            this.httpMessage.setRequestHeader(header);
        }
        catch (HttpMalformedHeaderException e) {
            LOGGER.warn("Could not Save Header: {}", (Object)header, (Object)e);
            throw new InvalidMessageDataException(Constant.messages.getString("http.panel.model.header.warn.malformed"), e);
        }
    }
}

