/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httppanel.view.impl.models.http.request;

import com.stackhawk.hste.extension.httppanel.InvalidMessageDataException;
import com.stackhawk.hste.extension.httppanel.view.impl.models.http.AbstractHttpStringHttpPanelViewModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class RequestStringHttpPanelViewModel
extends AbstractHttpStringHttpPanelViewModel {
    private static final Logger LOGGER = LogManager.getLogger(RequestStringHttpPanelViewModel.class);

    @Override
    public String getData() {
        if (this.httpMessage == null) {
            return "";
        }
        return this.httpMessage.getRequestHeader().toString().replaceAll("\r\n", "\n") + this.httpMessage.getRequestBody().toString();
    }

    @Override
    public void setData(String data) {
        if (this.httpMessage == null) {
            return;
        }
        String[] parts = data.split("\n\n");
        String header = parts[0].replaceAll("(?<!\r)\n", "\r\n");
        try {
            this.httpMessage.setRequestHeader(header);
        }
        catch (HttpMalformedHeaderException e) {
            LOGGER.warn("Could not Save Header: {}", (Object)header, (Object)e);
            throw new InvalidMessageDataException(Constant.messages.getString("http.panel.model.header.warn.malformed"), e);
        }
        String body = "";
        if (parts.length > 1) {
            body = data.substring(parts[0].length() + 2);
        }
        this.httpMessage.setRequestBody(body);
    }
}

