/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httppanel.view.impl.models.http.response;

import com.stackhawk.hste.extension.httppanel.InvalidMessageDataException;
import com.stackhawk.hste.extension.httppanel.view.impl.models.http.AbstractHttpByteHttpPanelViewModel;
import com.stackhawk.hste.extension.httppanel.view.impl.models.http.HttpPanelViewModelUtils;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class ResponseByteHttpPanelViewModel
extends AbstractHttpByteHttpPanelViewModel {
    private static final Logger LOGGER = LogManager.getLogger(ResponseByteHttpPanelViewModel.class);

    @Override
    public byte[] getData() {
        if (this.httpMessage == null || this.httpMessage.getResponseHeader().isEmpty()) {
            return new byte[0];
        }
        byte[] headerBytes = this.httpMessage.getResponseHeader().toString().getBytes();
        byte[] bodyBytes = this.httpMessage.getResponseBody().getBytes();
        byte[] bytes = new byte[headerBytes.length + bodyBytes.length];
        System.arraycopy(headerBytes, 0, bytes, 0, headerBytes.length);
        System.arraycopy(bodyBytes, 0, bytes, headerBytes.length, bodyBytes.length);
        return bytes;
    }

    @Override
    public void setData(byte[] data) {
        if (this.httpMessage == null) {
            return;
        }
        int pos = HttpPanelViewModelUtils.findHeaderLimit(data);
        if (pos == -1) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Could not Save Header, limit not found. Header: {}", (Object)new String(data));
            }
            throw new InvalidMessageDataException(Constant.messages.getString("http.panel.model.header.warn.notfound"));
        }
        try {
            this.httpMessage.setResponseHeader(new String(data, 0, pos));
        }
        catch (HttpMalformedHeaderException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Could not Save Header: {}", (Object)Arrays.toString(data), (Object)e);
            }
            throw new InvalidMessageDataException(Constant.messages.getString("http.panel.model.header.warn.malformed"), e);
        }
        this.httpMessage.getResponseBody().setBody(ArrayUtils.subarray((byte[])data, (int)pos, (int)data.length));
    }
}

