/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httppanel.view.impl.models.http.response;

import com.stackhawk.hste.extension.httppanel.InvalidMessageDataException;
import com.stackhawk.hste.extension.httppanel.view.impl.models.http.AbstractHttpByteHttpPanelViewModel;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class ResponseHeaderByteHttpPanelViewModel
extends AbstractHttpByteHttpPanelViewModel {
    private static final Logger LOGGER = LogManager.getLogger(ResponseHeaderByteHttpPanelViewModel.class);

    @Override
    public byte[] getData() {
        if (this.httpMessage == null || this.httpMessage.getResponseHeader().isEmpty()) {
            return new byte[0];
        }
        return this.httpMessage.getResponseHeader().toString().getBytes();
    }

    @Override
    public void setData(byte[] data) {
        if (this.httpMessage == null) {
            return;
        }
        try {
            this.httpMessage.setResponseHeader(new String(data));
        }
        catch (HttpMalformedHeaderException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Could not Save Header: {}", (Object)Arrays.toString(data), (Object)e);
            }
            throw new InvalidMessageDataException(Constant.messages.getString("http.panel.model.header.warn.malformed"), e);
        }
    }
}

