/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httppanel.view.impl.models.http.response;

import com.stackhawk.hste.extension.httppanel.InvalidMessageDataException;
import com.stackhawk.hste.extension.httppanel.view.impl.models.http.AbstractHttpStringHttpPanelViewModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class ResponseHeaderStringHttpPanelViewModel
extends AbstractHttpStringHttpPanelViewModel {
    private static final Logger LOGGER = LogManager.getLogger(ResponseHeaderStringHttpPanelViewModel.class);

    @Override
    public String getData() {
        if (this.httpMessage == null || this.httpMessage.getResponseHeader().isEmpty()) {
            return "";
        }
        return this.httpMessage.getResponseHeader().toString().replaceAll("\r\n", "\n");
    }

    @Override
    public void setData(String data) {
        if (this.httpMessage == null) {
            return;
        }
        String header = data.replaceAll("(?<!\r)\n", "\r\n");
        try {
            this.httpMessage.setResponseHeader(header);
        }
        catch (HttpMalformedHeaderException e) {
            LOGGER.warn("Could not Save Header: {}", (Object)header, (Object)e);
            throw new InvalidMessageDataException(Constant.messages.getString("http.panel.model.header.warn.malformed"), e);
        }
    }
}

