/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httppanel.view.paramtable;

import com.stackhawk.hste.extension.httppanel.component.split.request.RequestSplitComponent;
import com.stackhawk.hste.extension.httppanel.view.DefaultHttpPanelViewModel;
import com.stackhawk.hste.extension.httppanel.view.HttpPanelView;
import com.stackhawk.hste.extension.httppanel.view.HttpPanelViewModel;
import com.stackhawk.hste.extension.httppanel.view.paramtable.HttpPanelParamTableModel;
import com.stackhawk.hste.extension.httppanel.view.paramtable.HttpPanelParamTableView;
import com.stackhawk.hste.view.HttpPanelManager;
import java.util.TreeSet;
import javax.swing.JComboBox;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.network.HtmlParameter;

public class ExtensionHttpPanelRequestQueryCookieTableView
extends ExtensionAdaptor {
    public static final String NAME = "ExtensionHttpPanelRequestQueryCookieTableView";

    public ExtensionHttpPanelRequestQueryCookieTableView() {
        super(NAME);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("http.panel.view.requestquery.ext.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            HttpPanelManager.getInstance().addRequestViewFactory("RequestSplit", new HttpPanelQueryCookieParamTableViewFactory());
        }
    }

    @Override
    public boolean canUnload() {
        return false;
    }

    @Override
    public void unload() {
        if (this.getView() != null) {
            HttpPanelManager panelManager = HttpPanelManager.getInstance();
            panelManager.removeRequestViewFactory("RequestSplit", "HttpPanelQueryCookieParamTableViewFactory");
            panelManager.removeRequestViews("RequestSplit", "HttpPanelParamTableView", (Object)RequestSplitComponent.ViewComponent.HEADER);
        }
    }

    @Override
    public String getAuthor() {
        return "HSTE Dev Team";
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    private static final class HttpPanelQueryCookieParamTableViewFactory
    implements HttpPanelManager.HttpPanelViewFactory {
        public static final String NAME = "HttpPanelQueryCookieParamTableViewFactory";

        private HttpPanelQueryCookieParamTableViewFactory() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public HttpPanelView getNewView() {
            return new HttpPanelQueryCookieParamTableView(new DefaultHttpPanelViewModel(), new HttpPanelQueryCookieParamTableModel());
        }

        @Override
        public Object getOptions() {
            return RequestSplitComponent.ViewComponent.HEADER;
        }
    }

    private static class HttpPanelQueryCookieParamTableView
    extends HttpPanelParamTableView {
        public HttpPanelQueryCookieParamTableView(HttpPanelViewModel model, HttpPanelParamTableModel tableModel) {
            super(model, tableModel);
        }

        @Override
        public String getTargetViewName() {
            return "";
        }

        @Override
        public JComboBox<HtmlParameter.Type> getComboBoxTypes() {
            JComboBox<HtmlParameter.Type> comboBoxTypes = new JComboBox<HtmlParameter.Type>();
            comboBoxTypes.addItem(HtmlParameter.Type.url);
            comboBoxTypes.addItem(HtmlParameter.Type.cookie);
            return comboBoxTypes;
        }
    }

    private static class HttpPanelQueryCookieParamTableModel
    extends HttpPanelParamTableModel {
        private static final long serialVersionUID = 869819957109403800L;

        private HttpPanelQueryCookieParamTableModel() {
        }

        @Override
        protected void loadAllParams() {
            this.allParams.addAll(this.httpMessage.getUrlParams());
            this.allParams.addAll(this.httpMessage.getRequestHeader().getCookieParams());
        }

        @Override
        public void saveAllParams() {
            TreeSet<HtmlParameter> get = new TreeSet<HtmlParameter>();
            TreeSet<HtmlParameter> cookies = new TreeSet<HtmlParameter>();
            for (HtmlParameter htmlParameter : this.allParams) {
                if (htmlParameter.getName().isEmpty()) continue;
                switch (htmlParameter.getType()) {
                    case url: {
                        get.add(htmlParameter);
                        break;
                    }
                    case cookie: {
                        cookies.add(htmlParameter);
                        break;
                    }
                    case form: {
                        break;
                    }
                }
            }
            this.httpMessage.setGetParams(get);
            this.httpMessage.setCookieParams(cookies);
        }

        @Override
        protected HtmlParameter getDefaultHtmlParameter() {
            return new HtmlParameter(HtmlParameter.Type.url, "", "");
        }
    }
}

