/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httppanel.view.syntaxhighlight;

import com.stackhawk.hste.extension.httppanel.Message;
import com.stackhawk.hste.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.network.HttpMessage;

public abstract class AutoDetectSyntaxHttpPanelTextArea
extends HttpPanelSyntaxHighlightTextArea {
    private static final long serialVersionUID = 293746373028878338L;
    private static final String AUTO_DETECT = "autodetect";
    private boolean isAutoDetectSyntax = true;

    @Override
    public void setMessage(Message aMessage) {
        super.setMessage(aMessage);
        if (this.isAutoDetectSyntax) {
            this.detectAndSetSyntax();
        }
    }

    public boolean isAutoDetectSyntax() {
        return this.isAutoDetectSyntax;
    }

    public void setAutoDetectSyntax(boolean enabled) {
        this.isAutoDetectSyntax = enabled;
        if (this.isAutoDetectSyntax) {
            this.detectAndSetSyntax();
        }
    }

    private void detectAndSetSyntax() {
        Message message = this.getMessage();
        if (message instanceof HttpMessage) {
            String syntax = this.detectSyntax((HttpMessage)message);
            this.setSyntaxEditingStyle(syntax);
        }
    }

    protected abstract String detectSyntax(HttpMessage var1);

    @Override
    public void loadConfiguration(String key, FileConfiguration fileConfiguration) {
        super.loadConfiguration(key, fileConfiguration);
        this.setAutoDetectSyntax(fileConfiguration.getBoolean(key + "syntax.autodetect", this.isAutoDetectSyntax));
    }

    @Override
    public void saveConfiguration(String key, FileConfiguration fileConfiguration) {
        super.saveConfiguration(key, fileConfiguration);
        fileConfiguration.setProperty(key + "syntax.autodetect", (Object)this.isAutoDetectSyntax);
    }
}

