/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httppanel.view.syntaxhighlight;

import com.stackhawk.hste.extension.httppanel.Message;
import com.stackhawk.hste.extension.httppanel.view.AbstractStringHttpPanelViewModel;
import com.stackhawk.hste.extension.httppanel.view.HttpPanelView;
import com.stackhawk.hste.extension.httppanel.view.HttpPanelViewModel;
import com.stackhawk.hste.extension.httppanel.view.HttpPanelViewModelEvent;
import com.stackhawk.hste.extension.httppanel.view.HttpPanelViewModelListener;
import com.stackhawk.hste.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import com.stackhawk.hste.extension.search.SearchMatch;
import com.stackhawk.hste.extension.search.SearchableHttpPanelView;
import com.stackhawk.hste.view.messagecontainer.http.DefaultSingleHttpMessageContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.commons.configuration.FileConfiguration;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;

public abstract class HttpPanelSyntaxHighlightTextView
implements HttpPanelView,
HttpPanelViewModelListener,
SearchableHttpPanelView {
    public static final String DEFAULT_MESSAGE_CONTAINER_NAME = "HttpMessagePanel";
    public static final String NAME = "HttpPanelSyntaxHighlightTextView";
    private static final String CAPTION_NAME = Constant.messages.getString("http.panel.view.text.name");
    private HttpPanelSyntaxHighlightTextArea httpPanelTextArea;
    private JPanel mainPanel;
    private AbstractStringHttpPanelViewModel model;
    private String configurationKey;
    private final String messageContainerName;

    public HttpPanelSyntaxHighlightTextView(AbstractStringHttpPanelViewModel model) {
        this(DEFAULT_MESSAGE_CONTAINER_NAME, model);
    }

    public HttpPanelSyntaxHighlightTextView(String messageContainerName, AbstractStringHttpPanelViewModel model) {
        this.model = model;
        this.messageContainerName = messageContainerName;
        this.configurationKey = "";
        this.init();
        this.model.addHttpPanelViewModelListener(this);
    }

    private void init() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.httpPanelTextArea = this.createHttpPanelTextArea();
        this.httpPanelTextArea.setEditable(false);
        this.httpPanelTextArea.setComponentPopupMenu(new CustomPopupMenu());
        RTextScrollPane scrollPane = new RTextScrollPane((RTextArea)this.httpPanelTextArea, false);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.mainPanel.add((Component)scrollPane, "Center");
    }

    protected JPanel getMainPanel() {
        return this.mainPanel;
    }

    protected abstract HttpPanelSyntaxHighlightTextArea createHttpPanelTextArea();

    protected HttpPanelSyntaxHighlightTextArea getHttpPanelTextArea() {
        return this.httpPanelTextArea;
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected) {
            this.httpPanelTextArea.requestFocusInWindow();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getCaptionName() {
        return CAPTION_NAME;
    }

    @Override
    public String getTargetViewName() {
        return "HttpPanelTextView";
    }

    @Override
    public int getPosition() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean isEnabled(Message msg) {
        return true;
    }

    @Override
    public boolean hasChanged() {
        return true;
    }

    @Override
    public JComponent getPane() {
        return this.mainPanel;
    }

    @Override
    public boolean isEditable() {
        return this.httpPanelTextArea.isEditable();
    }

    @Override
    public void setEditable(boolean editable) {
        this.httpPanelTextArea.setEditable(editable);
    }

    @Override
    public HttpPanelViewModel getModel() {
        return this.model;
    }

    @Override
    public void dataChanged(HttpPanelViewModelEvent e) {
        this.httpPanelTextArea.setMessage(this.model.getMessage());
        boolean isEditable = this.httpPanelTextArea.isEditable();
        boolean empty = this.model.getData().isEmpty();
        if (empty || !isEditable) {
            this.httpPanelTextArea.discardAllEdits();
        }
        this.setModelData(this.model.getData());
        this.httpPanelTextArea.setCaretPosition(0);
        if (empty || !isEditable) {
            this.httpPanelTextArea.discardAllEdits();
        }
    }

    protected void setModelData(String data) {
        this.httpPanelTextArea.setText(data);
    }

    @Override
    public void save() {
        this.model.setData(this.httpPanelTextArea.getText());
    }

    @Override
    public void search(Pattern p, List<SearchMatch> matches) {
        this.httpPanelTextArea.search(p, matches);
    }

    @Override
    public void highlight(SearchMatch sm) {
        this.httpPanelTextArea.highlight(sm);
    }

    @Override
    public void setParentConfigurationKey(String configurationKey) {
        this.configurationKey = configurationKey + "HttpPanelSyntaxHighlightTextView.";
    }

    @Override
    public void loadConfiguration(FileConfiguration fileConfiguration) {
        this.httpPanelTextArea.loadConfiguration(this.configurationKey, fileConfiguration);
    }

    @Override
    public void saveConfiguration(FileConfiguration fileConfiguration) {
        this.httpPanelTextArea.saveConfiguration(this.configurationKey, fileConfiguration);
    }

    protected class CustomPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        protected CustomPopupMenu() {
        }

        @Override
        public void show(Component invoker, int x, int y) {
            if (!HttpPanelSyntaxHighlightTextView.this.httpPanelTextArea.isFocusOwner()) {
                HttpPanelSyntaxHighlightTextView.this.httpPanelTextArea.requestFocusInWindow();
            }
            if (HttpPanelSyntaxHighlightTextView.this.httpPanelTextArea.getMessage() instanceof HttpMessage) {
                DefaultSingleHttpMessageContainer messageContainer = new DefaultSingleHttpMessageContainer(HttpPanelSyntaxHighlightTextView.this.messageContainerName, (Component)((Object)HttpPanelSyntaxHighlightTextView.this.httpPanelTextArea), (HttpMessage)HttpPanelSyntaxHighlightTextView.this.httpPanelTextArea.getMessage());
                View.getSingleton().getPopupMenu().show(messageContainer, x, y);
            } else {
                View.getSingleton().getPopupMenu().show((Component)((Object)HttpPanelSyntaxHighlightTextView.this.httpPanelTextArea), x, y);
            }
        }
    }
}

