/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httppanel.view.syntaxhighlight.components.split.response;

import com.stackhawk.hste.extension.httppanel.view.impl.models.http.response.ResponseHeaderStringHttpPanelViewModel;
import com.stackhawk.hste.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import com.stackhawk.hste.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextView;
import com.stackhawk.hste.extension.httppanel.view.util.HttpTextViewUtils;
import com.stackhawk.hste.extension.search.SearchMatch;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextArea;

public class HttpResponseHeaderPanelSyntaxHighlightTextView
extends HttpPanelSyntaxHighlightTextView {
    public HttpResponseHeaderPanelSyntaxHighlightTextView(ResponseHeaderStringHttpPanelViewModel model) {
        super(model);
    }

    @Override
    protected HttpPanelSyntaxHighlightTextArea createHttpPanelTextArea() {
        return new HttpResponseHeaderPanelSyntaxHighlightTextArea();
    }

    private static class HttpResponseHeaderPanelSyntaxHighlightTextArea
    extends HttpPanelSyntaxHighlightTextArea {
        private static final long serialVersionUID = 6197189781594557597L;
        private static ResponseHeaderTokenMakerFactory tokenMakerFactory = null;

        @Override
        public void search(Pattern p, List<SearchMatch> matches) {
            Matcher m = p.matcher(this.getText());
            while (m.find()) {
                int[] position = HttpTextViewUtils.getViewToHeaderPosition((JTextArea)((Object)this), m.start(), m.end());
                if (position.length == 0) {
                    return;
                }
                matches.add(new SearchMatch(SearchMatch.Location.RESPONSE_HEAD, position[0], position[1]));
            }
        }

        @Override
        public void highlight(SearchMatch sm) {
            if (!SearchMatch.Location.RESPONSE_HEAD.equals((Object)sm.getLocation())) {
                return;
            }
            int[] pos = HttpTextViewUtils.getHeaderToViewPosition((JTextArea)((Object)this), sm.getMessage().getResponseHeader().toString(), sm.getStart(), sm.getEnd());
            if (pos.length == 0) {
                return;
            }
            this.highlight(pos[0], pos[1]);
        }

        @Override
        protected synchronized HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory getTokenMakerFactory() {
            if (tokenMakerFactory == null) {
                tokenMakerFactory = new ResponseHeaderTokenMakerFactory();
            }
            return tokenMakerFactory;
        }

        private static class ResponseHeaderTokenMakerFactory
        extends HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory {
        }
    }
}

