/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httppanel.view.text;

import com.stackhawk.hste.extension.httppanel.Message;
import com.stackhawk.hste.extension.httppanel.view.AbstractStringHttpPanelViewModel;
import com.stackhawk.hste.extension.httppanel.view.HttpPanelView;
import com.stackhawk.hste.extension.httppanel.view.HttpPanelViewModel;
import com.stackhawk.hste.extension.httppanel.view.HttpPanelViewModelEvent;
import com.stackhawk.hste.extension.httppanel.view.HttpPanelViewModelListener;
import com.stackhawk.hste.extension.httppanel.view.text.HttpPanelTextArea;
import com.stackhawk.hste.extension.search.SearchMatch;
import com.stackhawk.hste.extension.search.SearchableHttpPanelView;
import com.stackhawk.hste.view.messagecontainer.http.DefaultSingleHttpMessageContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;

public abstract class HttpPanelTextView
implements HttpPanelView,
HttpPanelViewModelListener,
SearchableHttpPanelView {
    public static final String DEFAULT_MESSAGE_CONTAINER_NAME = "HttpMessagePanel";
    public static final String NAME = "HttpPanelTextView";
    private static final String CAPTION_NAME = Constant.messages.getString("http.panel.view.text.name");
    private HttpPanelTextArea httpPanelTextArea;
    private JPanel mainPanel;
    private AbstractStringHttpPanelViewModel model;
    private final String messageContainerName;

    public HttpPanelTextView(AbstractStringHttpPanelViewModel model) {
        this(DEFAULT_MESSAGE_CONTAINER_NAME, model);
    }

    public HttpPanelTextView(String messageContainerName, AbstractStringHttpPanelViewModel model) {
        this.model = model;
        this.messageContainerName = messageContainerName;
        this.init();
        this.model.addHttpPanelViewModelListener(this);
    }

    private void init() {
        this.httpPanelTextArea = this.createHttpPanelTextArea();
        this.httpPanelTextArea.setEditable(false);
        this.httpPanelTextArea.setLineWrap(true);
        this.httpPanelTextArea.setComponentPopupMenu(new CustomPopupMenu());
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)new JScrollPane(this.httpPanelTextArea), "Center");
    }

    protected abstract HttpPanelTextArea createHttpPanelTextArea();

    @Override
    public void setSelected(boolean selected) {
        if (selected) {
            this.httpPanelTextArea.requestFocusInWindow();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getCaptionName() {
        return CAPTION_NAME;
    }

    @Override
    public String getTargetViewName() {
        return "";
    }

    @Override
    public int getPosition() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean isEnabled(Message msg) {
        return true;
    }

    @Override
    public boolean hasChanged() {
        return true;
    }

    @Override
    public JComponent getPane() {
        return this.mainPanel;
    }

    @Override
    public boolean isEditable() {
        return this.httpPanelTextArea.isEditable();
    }

    @Override
    public void setEditable(boolean editable) {
        this.httpPanelTextArea.setEditable(editable);
        if (!editable) {
            this.httpPanelTextArea.discardAllEdits();
        }
    }

    @Override
    public HttpPanelViewModel getModel() {
        return this.model;
    }

    @Override
    public void dataChanged(HttpPanelViewModelEvent e) {
        this.httpPanelTextArea.setMessage(this.model.getMessage());
        this.httpPanelTextArea.setText(this.model.getData());
        this.httpPanelTextArea.setCaretPosition(0);
    }

    @Override
    public void save() {
        this.model.setData(this.httpPanelTextArea.getText());
    }

    @Override
    public void search(Pattern p, List<SearchMatch> matches) {
        this.httpPanelTextArea.search(p, matches);
    }

    @Override
    public void highlight(SearchMatch sm) {
        this.httpPanelTextArea.highlight(sm);
    }

    @Override
    public void setParentConfigurationKey(String configurationKey) {
    }

    @Override
    public void loadConfiguration(FileConfiguration fileConfiguration) {
    }

    @Override
    public void saveConfiguration(FileConfiguration fileConfiguration) {
    }

    protected class CustomPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        protected CustomPopupMenu() {
        }

        @Override
        public void show(Component invoker, int x, int y) {
            if (!HttpPanelTextView.this.httpPanelTextArea.isFocusOwner()) {
                HttpPanelTextView.this.httpPanelTextArea.requestFocusInWindow();
            }
            if (HttpPanelTextView.this.httpPanelTextArea.getMessage() instanceof HttpMessage) {
                DefaultSingleHttpMessageContainer messageContainer = new DefaultSingleHttpMessageContainer(HttpPanelTextView.this.messageContainerName, HttpPanelTextView.this.httpPanelTextArea, (HttpMessage)HttpPanelTextView.this.httpPanelTextArea.getMessage());
                View.getSingleton().getPopupMenu().show(messageContainer, x, y);
            } else {
                View.getSingleton().getPopupMenu().show(HttpPanelTextView.this.httpPanelTextArea, x, y);
            }
        }
    }
}

