/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httpsessions;

import com.stackhawk.hste.extension.httpsessions.HttpSessionToken;
import com.stackhawk.hste.utils.HsteTextField;
import com.stackhawk.hste.view.AbstractFormDialog;
import java.awt.Dialog;
import java.util.List;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.parosproxy.paros.Constant;

class DialogAddToken
extends AbstractFormDialog {
    private static final long serialVersionUID = -7700616092385163201L;
    private static final String DIALOG_TITLE = Constant.messages.getString("httpsessions.options.dialog.token.add.title");
    private static final String CONFIRM_BUTTON_LABEL = Constant.messages.getString("httpsessions.options.dialog.token.add.button.confirm");
    private static final String NAME_FIELD_LABEL = Constant.messages.getString("httpsessions.options.dialog.token.field.label.name");
    private static final String ENABLED_FIELD_LABEL = Constant.messages.getString("httpsessions.options.dialog.token.field.label.enabled");
    private static final String TITLE_NAME_REPEATED_DIALOG = Constant.messages.getString("httpsessions.options.dialog.token.warning.name.repeated.title");
    private static final String TEXT_NAME_REPEATED_DIALOG = Constant.messages.getString("httpsessions.options.dialog.token.warning.name.repeated.text");
    private HsteTextField nameTextField;
    private JCheckBox enabledCheckBox;
    protected HttpSessionToken token;
    private List<HttpSessionToken> tokens;

    public DialogAddToken(Dialog owner) {
        super(owner, DIALOG_TITLE);
    }

    protected DialogAddToken(Dialog owner, String title) {
        super(owner, title);
    }

    @Override
    protected JPanel getFieldsPanel() {
        JPanel fieldsPanel = new JPanel();
        GroupLayout layout = new GroupLayout(fieldsPanel);
        fieldsPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JLabel nameLabel = new JLabel(NAME_FIELD_LABEL);
        JLabel enabledLabel = new JLabel(ENABLED_FIELD_LABEL);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(nameLabel).addComponent(enabledLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getNameTextField()).addComponent(this.getEnabledCheckBox())));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(nameLabel).addComponent(this.getNameTextField())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(enabledLabel).addComponent(this.getEnabledCheckBox())));
        return fieldsPanel;
    }

    @Override
    protected String getConfirmButtonLabel() {
        return CONFIRM_BUTTON_LABEL;
    }

    @Override
    protected void init() {
        this.getNameTextField().setText("");
        this.getEnabledCheckBox().setSelected(true);
        this.token = null;
    }

    @Override
    protected boolean validateFields() {
        String tokenName = this.getNormalisedName();
        for (HttpSessionToken t : this.tokens) {
            if (!tokenName.equals(t.getName())) continue;
            JOptionPane.showMessageDialog(this, TEXT_NAME_REPEATED_DIALOG, TITLE_NAME_REPEATED_DIALOG, 1);
            this.getNameTextField().requestFocusInWindow();
            return false;
        }
        return true;
    }

    @Override
    protected void performAction() {
        this.token = new HttpSessionToken(this.getNormalisedName(), this.getEnabledCheckBox().isSelected());
    }

    @Override
    protected void clearFields() {
        this.getNameTextField().setText("");
        this.getNameTextField().discardAllEdits();
    }

    public HttpSessionToken getToken() {
        return this.token;
    }

    protected HsteTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new HsteTextField(25);
            this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.checkAndEnableConfirmButton();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.checkAndEnableConfirmButton();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.checkAndEnableConfirmButton();
                }

                private void checkAndEnableConfirmButton() {
                    DialogAddToken.this.setConfirmButtonEnabled(DialogAddToken.this.getNameTextField().getDocument().getLength() > 0);
                }
            });
        }
        return this.nameTextField;
    }

    protected JCheckBox getEnabledCheckBox() {
        if (this.enabledCheckBox == null) {
            this.enabledCheckBox = new JCheckBox();
        }
        return this.enabledCheckBox;
    }

    public void setTokens(List<HttpSessionToken> tokens) {
        this.tokens = tokens;
    }

    public void clear() {
        this.tokens = null;
        this.token = null;
    }

    protected String getNormalisedName() {
        return this.getNameTextField().getText().toLowerCase(Locale.ROOT);
    }
}

