/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httpsessions;

import com.stackhawk.hste.extension.httpsessions.HttpSessionToken;
import com.stackhawk.hste.view.AbstractMultipleOptionsTableModel;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;

public class OptionsHttpSessionsTableModel
extends AbstractMultipleOptionsTableModel<HttpSessionToken> {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("httpsessions.options.table.header.enabled"), Constant.messages.getString("httpsessions.options.table.header.token")};
    private static final int COLUMN_COUNT = COLUMN_NAMES.length;
    private List<HttpSessionToken> tokens = new ArrayList<HttpSessionToken>(0);

    @Override
    public List<HttpSessionToken> getElements() {
        return this.tokens;
    }

    public List<HttpSessionToken> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<HttpSessionToken> tokens) {
        this.tokens = new ArrayList<HttpSessionToken>(tokens.size());
        for (HttpSessionToken token : tokens) {
            this.tokens.add(new HttpSessionToken(token));
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.tokens.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ((HttpSessionToken)this.getElement(rowIndex)).isEnabled();
            }
            case 1: {
                return ((HttpSessionToken)this.getElement(rowIndex)).getName();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && aValue instanceof Boolean) {
            this.tokens.get(rowIndex).setEnabled((Boolean)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

