/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httpsessions;

import com.stackhawk.hste.extension.httpsessions.HttpSession;
import com.stackhawk.hste.extension.httpsessions.HttpSessionsPanel;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;

public class PopupMenuItemCopySessionToken
extends ExtensionPopupMenuItem
implements ClipboardOwner {
    private static final long serialVersionUID = -2462677795340933336L;
    private final HttpSessionsPanel httpSessionsPanel;

    public PopupMenuItemCopySessionToken(HttpSessionsPanel panel) {
        super(Constant.messages.getString("httpsessions.popup.session.copyToken"));
        this.httpSessionsPanel = panel;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HttpSession item = PopupMenuItemCopySessionToken.this.httpSessionsPanel.getSelectedSession();
                if (item == null) {
                    return;
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(item.getTokenValuesString()), PopupMenuItemCopySessionToken.this);
            }
        });
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        if ("httpsessions".equals(invoker.getName())) {
            this.setEnabled(this.httpSessionsPanel.getSelectedSession() != null);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

