/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httpsessions;

import com.stackhawk.hste.extension.httpsessions.ExtensionHttpSessions;
import com.stackhawk.hste.extension.httpsessions.HttpSession;
import com.stackhawk.hste.extension.httpsessions.HttpSessionsPanel;
import com.stackhawk.hste.extension.httpsessions.HttpSessionsSite;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;

public class PopupMenuRemoveSession
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    private ExtensionHttpSessions extension;

    public PopupMenuRemoveSession() {
        super(Constant.messages.getString("httpsessions.popup.session.remove"));
        this.initialize();
    }

    public void setExtension(ExtensionHttpSessions extension) {
        this.extension = extension;
    }

    private void initialize() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HttpSessionsPanel panel = PopupMenuRemoveSession.this.extension.getHttpSessionsPanel();
                HttpSessionsSite site = panel.getCurrentHttpSessionSite();
                if (site == null) {
                    return;
                }
                HttpSession item = panel.getSelectedSession();
                site.removeHttpSession(item);
            }
        });
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        if ("httpsessions".equals(invoker.getName())) {
            this.setEnabled(this.extension.getHttpSessionsPanel().getSelectedSession() != null);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

