/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.httpsessions;

import com.stackhawk.hste.extension.httpsessions.HttpSessionsPanel;
import com.stackhawk.hste.extension.search.ExtensionSearch;
import java.awt.Component;
import java.util.regex.Pattern;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;

public class PopupMenuSessionSearch
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    private ExtensionSearch extSearch = null;
    private HttpSessionsPanel httpSessionsPanel = null;

    public PopupMenuSessionSearch(HttpSessionsPanel httpSessionsPanel) {
        super(Constant.messages.getString("httpsessions.popup.find"));
        this.httpSessionsPanel = httpSessionsPanel;
        this.addActionListener(ae -> {
            Pattern pattern = Pattern.compile(httpSessionsPanel.getSelectedSession().getTokenValuesString().replaceAll(";", "|"));
            this.search(pattern);
        });
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        if ("httpsessions".equals(invoker.getName())) {
            this.setEnabled(this.httpSessionsPanel.getSelectedSession() != null);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    private ExtensionSearch getExtensionSearch() {
        if (this.extSearch == null) {
            this.extSearch = Control.getSingleton().getExtensionLoader().getExtension(ExtensionSearch.class);
        }
        return this.extSearch;
    }

    private void search(Pattern p) {
        this.getExtensionSearch().search(p.pattern(), ExtensionSearch.Type.All, true, false);
    }
}

