/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.keyboard;

import com.stackhawk.hste.view.HsteMenuItem;
import javax.swing.KeyStroke;
import org.parosproxy.paros.Constant;

class KeyboardMapping {
    private HsteMenuItem menuItem;
    private String i18nKey;

    public KeyboardMapping() {
    }

    public KeyboardMapping(String i18nKey) {
        this.i18nKey = i18nKey;
    }

    public KeyboardMapping(HsteMenuItem menuItem) {
        this.menuItem = menuItem;
    }

    public String getName() {
        if (this.menuItem != null) {
            return this.menuItem.getText();
        }
        return null;
    }

    public String getIdentifier() {
        if (this.menuItem != null) {
            return this.menuItem.getIdentifier();
        }
        return this.i18nKey;
    }

    public KeyStroke getKeyStroke() {
        if (this.menuItem != null) {
            return this.menuItem.getAccelerator();
        }
        return null;
    }

    public KeyStroke getDefaultKeyStroke() {
        if (this.menuItem != null) {
            return this.menuItem.getDefaultAccelerator();
        }
        return null;
    }

    public String getKeyStrokeKeyCodeString() {
        if (this.menuItem == null || this.menuItem.getAccelerator() == null) {
            return "";
        }
        return KeyboardMapping.keyString(this.menuItem.getAccelerator().getKeyCode());
    }

    public static String keyString(int keyCode) {
        if (keyCode >= 112 && keyCode <= 123) {
            return "F" + (keyCode - 112 + 1);
        }
        if (keyCode == 38) {
            return Constant.messages.getString("keyboard.key.up");
        }
        if (keyCode == 40) {
            return Constant.messages.getString("keyboard.key.down");
        }
        if (keyCode == 37) {
            return Constant.messages.getString("keyboard.key.left");
        }
        if (keyCode == 39) {
            return Constant.messages.getString("keyboard.key.right");
        }
        return String.valueOf((char)keyCode).toUpperCase();
    }

    public static char keyCode(String keyStr) {
        if (keyStr.length() == 1) {
            return keyStr.charAt(0);
        }
        if (keyStr.startsWith("F")) {
            return (char)(112 + Integer.parseInt(keyStr.substring(1)) - 1);
        }
        if (keyStr.equals(Constant.messages.getString("keyboard.key.up"))) {
            return '&';
        }
        if (keyStr.equals(Constant.messages.getString("keyboard.key.down"))) {
            return '(';
        }
        if (keyStr.equals(Constant.messages.getString("keyboard.key.left"))) {
            return '%';
        }
        if (keyStr.equals(Constant.messages.getString("keyboard.key.right"))) {
            return '\'';
        }
        return '\u0000';
    }

    public String getKeyStrokeModifiersString() {
        if (this.menuItem == null || this.menuItem.getAccelerator() == null) {
            return "";
        }
        return KeyboardMapping.modifiersString(this.menuItem.getAccelerator().getModifiers());
    }

    public static String modifiersString(int modifiers) {
        StringBuilder sb = new StringBuilder();
        if ((modifiers & 0x80) > 0) {
            sb.append(Constant.messages.getString("keyboard.key.control"));
            sb.append(" ");
        }
        if ((modifiers & 0x200) > 0) {
            sb.append(Constant.messages.getString("keyboard.key.alt"));
            sb.append(" ");
        }
        if ((modifiers & 0x40) > 0) {
            sb.append(Constant.messages.getString("keyboard.key.shift"));
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getKeyStrokeString() {
        if (this.menuItem == null || this.menuItem.getAccelerator() == null) {
            return "";
        }
        return this.getKeyStrokeModifiersString() + " " + this.getKeyStrokeKeyCodeString();
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        if (this.menuItem != null) {
            this.menuItem.setAccelerator(keyStroke);
        }
    }

    public int hashCode() {
        return 31 * super.hashCode() + (this.menuItem == null ? 0 : this.menuItem.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyboardMapping other = (KeyboardMapping)obj;
        return !(this.menuItem == null ? other.menuItem != null : !this.menuItem.equals(other.menuItem));
    }
}

