/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.keyboard;

import com.stackhawk.hste.extension.keyboard.KeyboardShortcut;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.Constant;

public class KeyboardShortcutTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("keyboard.options.table.header.menu"), Constant.messages.getString("keyboard.options.table.header.mods"), Constant.messages.getString("keyboard.options.table.header.key")};
    private static final int COLUMN_COUNT = COLUMN_NAMES.length;
    private List<KeyboardShortcut> tokens = new ArrayList<KeyboardShortcut>(0);

    protected List<KeyboardShortcut> getElements() {
        return this.tokens;
    }

    public void setShortcuts(List<KeyboardShortcut> shortcuts) {
        this.tokens = new ArrayList<KeyboardShortcut>(shortcuts.size());
        for (KeyboardShortcut token : shortcuts) {
            this.tokens.add(token);
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.tokens.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.tokens.get(rowIndex).getName();
            }
            case 1: {
                return this.tokens.get(rowIndex).getKeyStrokeModifiersString();
            }
            case 2: {
                return this.tokens.get(rowIndex).getKeyStrokeKeyCodeString();
            }
        }
        return null;
    }

    public void addShortcut(KeyboardShortcut shortcut) {
        this.tokens.add(shortcut);
        this.fireTableDataChanged();
    }
}

