/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.lang;

import com.stackhawk.hste.utils.LocaleUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;

public final class LangImporter {
    private static final Logger LOGGER = LogManager.getLogger(LangImporter.class);
    private static final String MSG_SUCCESS = "options.lang.importer.dialog.message.success";
    private static final String MSG_ERROR = "options.lang.importer.dialog.message.error";
    private static final String MSG_FILE_NOT_FOUND = "options.lang.importer.dialog.message.filenotfound";

    private LangImporter() {
    }

    public static String importLanguagePack(String languagePack) {
        Pattern includedFilesPattern = LangImporter.createIncludedFilesPattern();
        int langFileCount = 0;
        String message = "";
        File F = new File(languagePack);
        try (ZipFile zipFile = new ZipFile(F.getAbsolutePath());){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                try (BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(zipEntry));){
                    byte[] buffer = new byte[2048];
                    String name = zipEntry.getName();
                    if (!includedFilesPattern.matcher(name).find()) continue;
                    ++langFileCount;
                    Path outputFile = Paths.get(Constant.getHsteInstall(), name);
                    try (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(outputFile, new OpenOption[0]), buffer.length);){
                        int size;
                        while ((size = bis.read(buffer, 0, buffer.length)) != -1) {
                            bos.write(buffer, 0, size);
                        }
                        bos.flush();
                    }
                }
            }
            message = langFileCount > 0 ? MSG_SUCCESS : MSG_ERROR;
        }
        catch (IOException e) {
            message = MSG_FILE_NOT_FOUND;
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (View.isInitialised()) {
            JOptionPane.showMessageDialog(null, Constant.messages.getString(message, langFileCount), Constant.messages.getString("options.lang.importer.dialog.title"), langFileCount > 0 ? 1 : 0);
        }
        return message;
    }

    static Pattern createIncludedFilesPattern() {
        String messagesFilesRegex = LocaleUtils.createResourceFilesRegex("Messages", ".properties");
        return Pattern.compile(messagesFilesRegex);
    }
}

