/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.log4j;

import com.stackhawk.hste.view.HsteMenuItem;
import com.stackhawk.hste.view.ScanStatus;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.LevelMatchFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;

public class ExtensionLog4j
extends ExtensionAdaptor {
    private static final String NAME = "ExtensionLog4j";
    private HsteMenuItem menuGarbageCollect = null;
    private ScanStatus scanStatus;

    public ExtensionLog4j() {
        super(NAME);
        this.setOrder(56);
        if (Constant.isDevMode() && View.isInitialised()) {
            this.scanStatus = new ScanStatus(new ImageIcon(ExtensionLog4j.class.getResource("/resource/icon/fugue/bug.png")), Constant.messages.getString("log4j.icon.title"));
            LoggerContext.getContext().getConfiguration().getRootLogger().addAppender((Appender)new ErrorAppender(this::handleError), null, null);
            View.getSingleton().getMainFrame().getMainFooterPanel().addFooterToolbarRightLabel(this.scanStatus.getCountLabel());
        }
    }

    private void handleError(String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.handleError(message));
            return;
        }
        this.scanStatus.incScanCount();
        View.getSingleton().getOutputPanel().append(message);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("log4j.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuGarbageCollect());
            if (this.scanStatus != null) {
                extensionHook.addSessionListener(new ResetCounterOnSessionChange(this.scanStatus));
            }
        }
    }

    private HsteMenuItem getMenuGarbageCollect() {
        if (this.menuGarbageCollect == null) {
            this.menuGarbageCollect = new HsteMenuItem("log4j.tools.menu.gc");
            this.menuGarbageCollect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Runtime.getRuntime().gc();
                }
            });
        }
        return this.menuGarbageCollect;
    }

    @Override
    public String getAuthor() {
        return "HSTE Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("log4j.desc");
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    static class ErrorAppender
    extends AbstractAppender {
        private static final Property[] NO_PROPERTIES = new Property[0];
        private final Consumer<String> logConsumer;

        ErrorAppender(Consumer<String> logConsumer) {
            super("HSTE-ErrorAppender", (Filter)LevelMatchFilter.newBuilder().setLevel(Level.ERROR).build(), (Layout)PatternLayout.newBuilder().withDisableAnsi(true).withCharset(StandardCharsets.UTF_8).withPattern("%m%n").build(), true, NO_PROPERTIES);
            this.logConsumer = logConsumer;
            this.start();
        }

        public void append(LogEvent event) {
            this.logConsumer.accept((String)((Object)((StringLayout)this.getLayout()).toSerializable(event)));
        }
    }

    private static class ResetCounterOnSessionChange
    implements SessionChangedListener {
        private int previousCount;
        private boolean starting;
        private ScanStatus scanStatus;

        public ResetCounterOnSessionChange(ScanStatus scanStatus) {
            this.scanStatus = scanStatus;
            this.starting = true;
        }

        @Override
        public void sessionAboutToChange(Session session) {
            EventQueue.invokeLater(() -> {
                this.previousCount = this.scanStatus.getScanCount();
            });
        }

        @Override
        public void sessionChanged(Session session) {
            if (this.starting) {
                this.starting = false;
                return;
            }
            EventQueue.invokeLater(() -> {
                this.scanStatus.setScanCount(this.scanStatus.getScanCount() - this.previousCount);
                this.previousCount = 0;
            });
        }

        @Override
        public void sessionScopeChanged(Session session) {
        }

        @Override
        public void sessionModeChanged(Control.Mode mode) {
        }
    }
}

