/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.proxies;

import com.stackhawk.hste.extension.proxies.DialogAddProxy;
import com.stackhawk.hste.extension.proxies.DialogModifyProxy;
import com.stackhawk.hste.extension.proxies.ExtensionProxies;
import com.stackhawk.hste.extension.proxies.OptionsLocalProxyPanel;
import com.stackhawk.hste.extension.proxies.OptionsProxiesTableModel;
import com.stackhawk.hste.extension.proxies.ProxiesParam;
import com.stackhawk.hste.extension.proxies.ProxiesParamProxy;
import com.stackhawk.hste.utils.FontUtils;
import com.stackhawk.hste.view.AbstractMultipleOptionsTablePanel;
import com.stackhawk.hste.view.LayoutHelper;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SortOrder;
import org.jdesktop.swingx.VerticalLayout;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.option.SecurityProtocolsPanel;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;

@Deprecated
public class OptionsProxiesPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private ProxiesMultipleOptionsPanel proxiesOptionsPanel;
    private JScrollPane proxiesScrollPane;
    private JPanel scrollPanel;
    private OptionsLocalProxyPanel mainProxyPanel;
    private SecurityProtocolsPanel securityProtocolsPanel;
    private OptionsProxiesTableModel proxiesModel;
    private String currentAddress;
    private int currentPort;
    private ExtensionProxies extension;

    public OptionsProxiesPanel(ExtensionProxies extension) {
        this.extension = extension;
        this.initialize();
    }

    private void initialize() {
        this.setName(Constant.messages.getString("proxies.options.title"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getScrollPane(), LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0));
    }

    private JScrollPane getScrollPane() {
        if (this.proxiesScrollPane == null) {
            this.proxiesScrollPane = new JScrollPane();
            this.proxiesScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.proxiesScrollPane.setViewportView(this.getScrollPanel());
        }
        return this.proxiesScrollPane;
    }

    private JPanel getScrollPanel() {
        if (this.scrollPanel == null) {
            this.scrollPanel = new JPanel((LayoutManager)new VerticalLayout());
            this.scrollPanel.add(this.getMainProxyPanel());
            this.scrollPanel.add(this.getSecurityProtocolsPanel());
            this.scrollPanel.add(this.getProxiesOptionsPanel());
        }
        return this.scrollPanel;
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam optionsParam = (OptionsParam)obj;
        ProxiesParam param = optionsParam.getParamSet(ProxiesParam.class);
        this.getMainProxyPanel().setProxy(param.getMainProxy());
        this.getSecurityProtocolsPanel().setSecurityProtocolsEnabled(param.getSecurityProtocolsEnabled());
        this.getProxiesModel().setProxies(param.getProxies());
        this.getProxiesOptionsPanel().setRemoveWithoutConfirmation(!param.isConfirmRemoveProxy());
        this.currentAddress = param.getMainProxy().getAddress();
        this.currentPort = param.getMainProxy().getPort();
    }

    @Override
    public void validateParam(Object obj) throws Exception {
        this.getSecurityProtocolsPanel().validateSecurityProtocols();
        ProxiesParamProxy mainProxy = this.getMainProxyPanel().getProxy();
        String newAddress = mainProxy.getAddress();
        int newPort = mainProxy.getPort();
        if (!(ExtensionProxies.isSameAddress(this.currentAddress, newAddress) && this.currentPort == newPort || this.extension.canListenOn(newAddress, newPort) && this.extension.getAdditionalProxy(newAddress, newPort) == null)) {
            throw new Exception(Constant.messages.getString("options.proxy.dialog.proxy.warning.fail.message", newAddress, Integer.toString(newPort)));
        }
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam optionsParam = (OptionsParam)obj;
        ProxiesParam param = optionsParam.getParamSet(ProxiesParam.class);
        List<ProxiesParamProxy> proxies = this.getProxiesModel().getElements();
        param.setMainProxy(this.getMainProxyPanel().getProxy());
        param.setSecurityProtocolsEnabled(this.getSecurityProtocolsPanel().getSelectedProtocols());
        param.setProxies(proxies);
        param.setConfirmRemoveProxy(!this.getProxiesOptionsPanel().isRemoveWithoutConfirmation());
    }

    private ProxiesMultipleOptionsPanel getProxiesOptionsPanel() {
        if (this.proxiesOptionsPanel == null) {
            this.proxiesOptionsPanel = new ProxiesMultipleOptionsPanel(this.getProxiesModel(), this.extension);
            this.proxiesOptionsPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("options.proxy.additional.title"), 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
        }
        return this.proxiesOptionsPanel;
    }

    private OptionsLocalProxyPanel getMainProxyPanel() {
        if (this.mainProxyPanel == null) {
            this.mainProxyPanel = new OptionsLocalProxyPanel();
        }
        return this.mainProxyPanel;
    }

    private SecurityProtocolsPanel getSecurityProtocolsPanel() {
        if (this.securityProtocolsPanel == null) {
            this.securityProtocolsPanel = new SecurityProtocolsPanel();
        }
        return this.securityProtocolsPanel;
    }

    private OptionsProxiesTableModel getProxiesModel() {
        if (this.proxiesModel == null) {
            this.proxiesModel = new OptionsProxiesTableModel();
        }
        return this.proxiesModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.localproxy";
    }

    private static class ProxiesMultipleOptionsPanel
    extends AbstractMultipleOptionsTablePanel<ProxiesParamProxy> {
        private static final long serialVersionUID = -115340627058929308L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("options.proxy.dialog.proxy.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("options.proxy.dialog.proxy.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("options.proxy.dialog.proxy.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("options.proxy.dialog.proxy.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("options.proxy.dialog.proxy.remove.checkbox.label");
        private DialogAddProxy addDialog = null;
        private DialogModifyProxy modifyDialog = null;
        private ExtensionProxies extension;

        public ProxiesMultipleOptionsPanel(OptionsProxiesTableModel model, ExtensionProxies extension) {
            super(model);
            this.extension = extension;
            this.getTable().getColumnExt(0).setPreferredWidth(20);
            this.getTable().setVisibleRowCount(10);
            this.getTable().setSortOrder(1, SortOrder.ASCENDING);
        }

        @Override
        public ProxiesParamProxy showAddDialogue() {
            if (this.addDialog == null) {
                this.addDialog = new DialogAddProxy((Dialog)View.getSingleton().getOptionsDialog(null), this.extension);
                this.addDialog.pack();
            }
            this.addDialog.setVisible(true);
            ProxiesParamProxy proxy = this.addDialog.getProxy();
            this.addDialog.clear();
            return proxy;
        }

        @Override
        public ProxiesParamProxy showModifyDialogue(ProxiesParamProxy e) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogModifyProxy((Dialog)View.getSingleton().getOptionsDialog(null), this.extension);
                this.modifyDialog.pack();
            }
            this.modifyDialog.setProxy(e);
            this.modifyDialog.setVisible(true);
            ProxiesParamProxy proxy = this.modifyDialog.getProxy();
            this.modifyDialog.clear();
            return proxy;
        }

        @Override
        public boolean showRemoveDialogue(ProxiesParamProxy e) {
            JCheckBox removeWithoutConfirmationCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] messages = new Object[]{REMOVE_DIALOG_TEXT, " ", removeWithoutConfirmationCheckBox};
            int option = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), messages, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (option == 0) {
                this.setRemoveWithoutConfirmation(removeWithoutConfirmationCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }
}

